% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_central_chi_squared_distribution.R
\name{non_central_chi_squared_distribution}
\alias{non_central_chi_squared_distribution}
\alias{non_central_chi_squared_pdf}
\alias{non_central_chi_squared_lpdf}
\alias{non_central_chi_squared_cdf}
\alias{non_central_chi_squared_lcdf}
\alias{non_central_chi_squared_quantile}
\title{Noncentral Chi-Squared Distribution Functions}
\usage{
non_central_chi_squared_pdf(x, df, lambda)

non_central_chi_squared_lpdf(x, df, lambda)

non_central_chi_squared_cdf(x, df, lambda)

non_central_chi_squared_lcdf(x, df, lambda)

non_central_chi_squared_quantile(p, df, lambda)
}
\arguments{
\item{x}{quantile}

\item{df}{degrees of freedom (df > 0)}

\item{lambda}{noncentrality parameter (lambda >= 0)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Noncentral Chi-Squared distribution.
}
\examples{
\dontrun{
# Noncentral Chi-Squared distribution with 3 degrees of freedom and noncentrality
# parameter 1
non_central_chi_squared_pdf(2, 3, 1)
non_central_chi_squared_lpdf(2, 3, 1)
non_central_chi_squared_cdf(2, 3, 1)
non_central_chi_squared_lcdf(2, 3, 1)
non_central_chi_squared_quantile(0.5, 3, 1)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/nc_chi_squared_dist.html}{Boost Documentation} for more details on the mathematical background.
}
