% Generated by roxygen2 (4.0.0): do not edit by hand
\name{buildEstimationProcedure}
\alias{buildEstimationProcedure}
\title{Build a boostr compatible estimation procedure.}
\usage{
buildEstimationProcedure(train, predict = stats::predict,
  learningSet = "data", predictionSet = "newdata", modelName = "object")
}
\arguments{
\item{train}{a function that learns from data to produce a model}

\item{predict}{a function that leverages the model from \code{train} to
generate predictions from new data.}

\item{learningSet}{a string indicating the name of the argument in
\code{train}'s signature that passes data inside \code{train}.}

\item{predictionSet}{a string indicating the name of the argument in
\code{predict}'s signature that indicates the observation to predicate
responses for.}

\item{modelName}{a string indicating the name of the argument in
\code{predict}'s signature that passes the model from \code{train} inside
\code{predict}.}
}
\value{
An '\code{estimationProcedure}' object which is compatible with the
boostr framework. Meaning, the output is a function factory  which accepts
arguments
\item{data}{the data to be passed to \code{train}.}
\item{.trainArgs}{a list of arguments to be passed to \code{train}, in
 addition to \code{data}. If the order of arguments in \code{train} is
 important, you'll need to respect that order inside \code{.trainArgs}.}
\item{.predictArgs}{a list of arguments to pass to \code{predict} in
addition to \code{modelName} and \code{predictionSet}. If the order
of these arguments matters, respect that order in \code{.predictArgs}.}

and returns a closure with arguments
\item{newdata}{the data whose response variable is to be estimated.}
\item{.predictArgs}{a list of arguments to pass to \code{predict} in
addition to \code{modelName} and \code{predictionSet}. This is defaulted
to the value of \code{.predictArgs} passed to the parent function, however
access to this has been granted as a convenience to the user. Again, if the
order of these arguments matters, respect that order in \code{.predictArgs}.}
}
\description{
A convenience function which builds a boostr compatible estimation
procedure from functions \code{train} and \code{predict}.
}
\section{Estimation Procedures}{


The examples below demonstrate two typical estimation procedures. For more
information, see the Estimation Procedures section in the vignette
\code{vignette(topic = "boostr_user_inputs", package="boostr")}.
}

\section{Warning}{

 This function makes the fundamental assumption that the design-pattern
linking \code{train} and {predict} is the common \code{train}-\code{predict}
pattern found in the design of \code{SVM} in the examples. If this is not the
case, you'll want to build assemble your procedure manually and call
\code{\link{wrapProcedure}} instead.
}
\examples{
\dontrun{
 # examples of estimation procedures
 library(class)
 library(e1071)

  kNN <- function(data, formula, k) {
   df <- model.frame(formula=formula, data=data)
   function(newdata) {
     knn(train=df[, -1], test=newdata, cl=df[, 1], k=k)
   }
  }

  SVM <- function(data, formula, cost) {
   model <- svm(formula, data, cost=cost)
   function(newdata) {
     predict(model, newdata)
   }
  }
}
}
\references{
Steven Pollack. (2014). Boost: a practical generalization of AdaBoost
(Master's Thesis). \url{http://pollackphoto.net/misc/masters_thesis.pdf}
}
\seealso{
Other Wrapper Generators: \code{\link{wrapAggregator}};
  \code{\link{wrapPerformanceAnalyzer}};
  \code{\link{wrapProcedure}}; \code{\link{wrapReweighter}}
}

