% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braidReport.R
\name{makeBraidReport}
\alias{makeBraidReport}
\title{Render a BRAID Report}
\usage{
makeBraidReport(analysis, compounds, levels, limits, control = list())
}
\arguments{
\item{analysis}{An object of class \code{braidAnalysis} produced by the
\code{\link[=runBraidAnalysis]{runBraidAnalysis()}} or \code{\link[=basicBraidAnalysis]{basicBraidAnalysis()}} functions}

\item{compounds}{A length-2 character vector containing the names of the
two compounds tested in the combination}

\item{levels}{Two levels at which the IAE should be evaluated}

\item{limits}{Two values representing the maximal achievable concentrations
for the compounds tested, used to esitmate the IAE}

\item{control}{A named list of additional control parameters adjusting the
appearance of the resulting report}
}
\value{
A graphical object containing all plots and tables, arranged
according to the desired format. The resulting object is optimized for a
single page, either portrait or landscape as specified in \code{control}
}
\description{
Produces a one page report depicting the results of a full BRAID analysis
for a single combination.
}
\details{
This function attempts, however foolhardily, to encompass many of the
details, plots, and values that the user might wish to report for a complete
BRAID analysis of a given drug combination.  All reports are built for a
single 8.5-by-11 inch page, either in landscape or potrait orientation, but
reports can be customized to contain more or less information.  Here is a
full list of what \emph{can} appear in the BRAID report:
\itemize{
\item A raw and smoothed plot of the actual measured response data; the raw plot
is built using \code{\link[=geom_braid]{geom_braid()}} or, for irregularly laid out data,
\code{\link[=geom_braid_glass]{geom_braid_glass()}}, while the smoothed data is built using
\code{\link[=geom_braid_smooth]{geom_braid_smooth()}}. (Included in all layouts)
\item A plot of residual errors and a smoothed surface plot of the predicted
additive surface based on the dose response behavior of the individual
compounds alone.  In cases of pronounced interaction, this will differ
significantly from the best-fit BRAID plots.  (Included in the dense layout)
\item A plot of residual errors and a smoothed surface plot of the best-fitting
BRAID surface. (Included in the all layouts)
\item A table of the best-fitting BRAID response surface parameters (Included in
all layouts)
\item A table of estimated IAE values at the specified effect levels (Included in
all layouts)
\item Two tables of the dose required of one drug to produce a desired effect
level (the first value in \code{levels}) in the presence of several doses of the
other drug; used to gauge the degree of potentiation.  (Included in the
standard and dense layouts)
\item Two plots depicting the predicted dose response of one drug in the presence
of various levels of the other, also used to gauge potentiation.  (Included
in the standard and dense layouts)
}

So the resulting report page can contain from six (simple layout) to twelve
(dense layout) elements depicting different aspects of the BRAID analysis.

The precise appearance of the report page is controlled by various elements
of the \code{control} parameter.  Though the default value of the parameter is
an empty list, several fields will be filled in if they are unspecified. The
full set of possible control options is:
\itemize{
\item \code{abbs}: A pair of character strings specifying the abbreviations of the
tested compounds.  By default, the abbreviations consist of the firs three
characters of each compound's name, but for some compound names this is not
an appropriate abbreviation  Abbreviations are used in many axis labels and
tables
\item \code{units}: If included, a single string or pair of strings specifying the
dose units for the two drugs tested, included in axis labels and tables.  If
left unspecified, units will not be included
\item \code{xscale}: Either a character string specifying a named transformation
object (e.g "log2", "log10", "sqrt") or a \code{ggplot2} continuous x-position
scale generated by \code{\link[ggplot2:scale_continuous]{ggplot2::scale_x_continuous()}} or related functions.  This
scale will be applied to the x-dimension of all surface plots and the
x-dimension of the first potentiation plot. If a \code{name} is specified for the
scale, this will be the x-axis label; otherwise other defaults will be used.
Default value for this control parameter is "log10".
\item \code{yscale}: Either a character string specifying a named transformation
object (e.g "log2", "log10", "sqrt") or a \code{ggplot2} continuous y-position
scale generated by \code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}} or related functions.  This
scale will be applied to the y-dimension of all surface plots and the
x-dimension of the second potentiation plot. If a \code{name} is specified for the
scale, this will be the y-axis label; otherwise other defaults will be used.
Default value for this control parameter is "log10".
\item \code{fillscale}: If included, continuous fill scale object generated by one of
several \code{ggplot2} continuous fill scale functions. This fill scale will
control the fill appearance for all \emph{effect} surface plots; fill colors
in residual error plots will use a different color palette.  In addition,
any names, labels, breaks, transformations, etc. included in this scale will
also be applied to the y-axis of both potentiation plots, as those also
represent the modeled effect.  If unspecified, will be set to a brewer
continuous color scale with palette "RdYlBu".
\item \code{colorscale}: If included, a discrete color scale object generated by one
of several \code{ggplot2} discrete color scale functions.  This color scale
controls the colors chosen for the curves in the two potentiation plots. If
left unspecified, will default to the output of
\code{\link[ggplot2:scale_colour_discrete]{ggplot2::scale_color_discrete()}}
\item \code{xname}: A string specifying the desired x-axis labels in surface plots.
Will be overridden if control parameter \code{xscale} is a scale object with a
non-empty \code{name} attribute. If unspecified, defaults the abbreviation of the
first compound followed by the units if included.
\item \code{yname}: A string specifying the desired y-axis labels in surface plots.
Will be overridden if control parameter \code{yscale} is a scale object with a
non-empty \code{name} attribute. If unspecified, defaults the abbreviation of the
second compound followed by the units if included.
\item \code{effectname}: The name of the modeled effect variable. Could be "Growth"
or "Survival" or "Activity".  The default value is simply "Effect"
\item \code{title}: A string containing the overall title of the report page.  If left
unspecified, will simply be the first compound "vs." the second
\item \code{contourcolor}: Contours of the smoothed surfaces at the levels specified
by the parameter \code{levels} are included in all smoothed plots.  By default,
they are black, but specifying this control parameter will change that color
\item \code{irregular}: If \code{TRUE}, the data are not assumed to lie on a regular grid
in the plotted, and will be visualized with \code{\link[=geom_braid_glass]{geom_braid_glass()}} rather than
\code{\link[=geom_braid]{geom_braid()}}
\item \code{swidth}: A numeric value specifying how widely the smooth surfaces should
be smoothed, passed as the \code{width} aesthetic to \code{\link[=geom_braid_smooth]{geom_braid_smooth()}}
\item \code{sheight}: A numeric value specifying how far in the y-direction the smooth
surfaces should be smoothed, passed as the \code{height} aesthetic to
\code{\link[=geom_braid_smooth]{geom_braid_smooth()}}
\item \code{npoints}: The density of points used in the smoothed plots.  See
\code{\link[=geom_braid_smooth]{geom_braid_smooth()}} for details
\item \code{leveltext}: A pair of strings indicating how the two IAE levels should be
displayed in tables.  In some cases, the precise number at which the IAE is
calculated does not reflect the level that the user wishes to express.  So
a user might want to refer to a relative survival value of 0.1 as IAE90 (for
90\% killing); or a log2-fold growth inhibition as IAE50 (for 50\% inhibition);
passing "50" or "90" as the \code{leveltext} in such cases will produce the
desired appearance.  If left unspecified, labels will simply be the string
representations of the paramter \code{levels}
\item \code{metrics}: A named numeric or named character vector specifying additional
metrics for the combination; they will be added to the table containing the
calculated IAE values. Numeric values will be rounded to three significant
figures; string values will be included as is.  Names will be parsed by
default, so the string "CI[90]" will be displayed with the "90" as a
subscript
\item \code{surftheme}: A \code{ggplot2} \code{theme} object specifying any additional theme
adjustments to add to all response surface plots
\item \code{curvetheme}: A \code{ggplot2} \code{theme} object specifying any additional theme
adjustments to add to both potentiation curve plots
\item \code{layout}: The specific layout to be used; determines which report elements
are included.  Can be "simple", "standard" (the default), or "dense"
\item \code{orientation}: The expected orientantion of the rendered page; can be
"portrait" (the default) or "landscape"
}
}
\examples{
surface <- synergisticExample
analysis <- runBraidAnalysis(measure~concA+concB, surface,
                             defaults=c(0,1), getCIs=FALSE)

report <- makeBraidReport(analysis,c("A Drug","B Drug"),
                          levels=c(0.5, 0.9),limits=c(5,5))
print(report)

control <- list(abbs=c("A","B"),units=c("\u00B5M"),leveltext=c("50","90"),
                xscale=scale_x_log10(breaks=c(0.1,0.5,2,10),
                labels=as.character),
                fillscale=scale_fill_viridis_c(option="A"),
                colorscale=scale_color_brewer(palette="Set1"),
                title="Example Analysis")
nextReport <- makeBraidReport(analysis,c("A Drug","B Drug"),
                              levels=c(0.5, 0.9),limits=c(5,5),
                              control=control)
print(nextReport)
}
