% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_separation.R, R/zzz_conventions.R
\name{detect_separation}
\alias{detect_separation}
\alias{detectSeparation}
\alias{print.detect_separation}
\title{Method for \code{\link{glm}} that tests for data separation and
finds which parameters have infinite maximum likelihood estimates
in generalized linear models with binomial responses}
\usage{
detect_separation(
  x,
  y,
  weights = rep(1, nobs),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = rep(0, nobs),
  family = gaussian(),
  control = list(),
  intercept = TRUE,
  singular.ok = TRUE
)

detectSeparation(
  x,
  y,
  weights = rep(1, nobs),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = rep(0, nobs),
  family = gaussian(),
  control = list(),
  intercept = TRUE,
  singular.ok = TRUE
)
}
\arguments{
\item{x}{\code{x} is a design matrix of dimension \code{n * p}.}

\item{y}{\code{y} is a vector of observations of length \code{n}.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used
    in the fitting process.  Should be \code{NULL} or a numeric vector.}

\item{start}{currently not used.}

\item{etastart}{currently not used.}

\item{mustart}{currently not used.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector of length equal to
    the number of cases.  One or more \code{\link[stats]{offset}} terms can be
    included in the formula instead or as well, and if more than one is
    specified their sum is used.  See \code{\link[stats]{model.offset}}.}

\item{family}{a description of the error distribution and link
    function to be used in the model.  For \code{glm} this can be a
    character string naming a family function, a family function or the
    result of a call to a family function.  For \code{glm.fit} only the
    third option is supported.  (See \code{\link[stats]{family}} for details of
    family functions.)}

\item{control}{a list of parameters controlling separation
detection. See \code{\link{detect_separation_control}} for
details.}

\item{intercept}{logical. Should an intercept be included in the
    \emph{null} model?}

\item{singular.ok}{logical. If \code{FALSE}, a singular model is an
error.}
}
\description{
\code{\link{detect_separation}} is a method for \code{\link{glm}}
that tests for the occurrence of complete or quasi-complete
separation in datasets for binomial response generalized linear
models, and finds which of the parameters will have infinite
maximum likelihood estimates. \code{\link{detect_separation}}
relies on the linear programming methods developed in Konis (2007).
}
\details{
For the definition of complete and quasi-complete separation, see
Albert and Anderson (1984).

\code{\link{detect_separation}} is a wrapper to the \code{separator}
function from the **safeBinaryRegression** R package, that can be
passed directly as a method to the \code{\link{glm}} function. See,
examples.

The interface to \code{separator} was designed by Ioannis Kosmidis
after correspondence with Kjell Konis, and a port of
\code{separator} has been included in **brglm2** under the
permission of Kjell Konis.

\code{detectSeparation} is an alias for \code{detect_separation}.
}
\note{
\code{detect_separation} will be removed from \pkg{brglm2} at
version 0.8. A new version of \code{detect_separation} is now
maintained in the \pkg{detectseparation} R package at
\url{https://cran.r-project.org/package=detectseparation}. In order
to use the version in \code{detect_separation} load first
\pkg{brglm2} and then \pkg{detectseparation}, i.e.
\code{library(brglm2); library(detectseparation)}.
}
\examples{

## endometrial data from Heinze \& Schemper (2002) (see ?endometrial)
data("endometrial", package = "brglm2")
endometrial_sep <- glm(HG ~ NV + PI + EH, data = endometrial,
                       family = binomial("logit"),
                       method = "detect_separation")
endometrial_sep
## The maximum likelihood estimate for NV is infinite
summary(update(endometrial_sep, method = "glm.fit"))

\dontrun{
## Example inspired by unpublished microeconometrics lecture notes by
## Achim Zeileis https://eeecon.uibk.ac.at/~zeileis/
## The maximum likelihood estimate of sourhernyes is infinite
data("MurderRates", package = "AER")
murder_sep <- glm(I(executions > 0) ~ time + income +
                  noncauc + lfp + southern, data = MurderRates,
                  family = binomial(), method = "detect_separation")
murder_sep
## which is also evident by the large estimated standard error for NV
murder_glm <- update(murder_sep, method = "glm.fit")
summary(murder_glm)
## and is also reveal by the divergence of the NV column of the
## result from the more computationally intensive check
check_infinite_estimates(murder_glm)
## Mean bias reduction via adjusted scores results in finite estimates
update(murder_glm, method = "brglm_fit")
}
}
\references{
Konis K (2007). *Linear Programming Algorithms for Detecting
Separated Data in Binary Logistic Regression
Models*. DPhil. University of Oxford.
\url{https://ora.ox.ac.uk/objects/uuid:8f9ee0d0-d78e-4101-9ab4-f9cbceed2a2a}

Konis K (2013). safeBinaryRegression: Safe Binary Regression. R
package version 0.1-3.
\url{https://CRAN.R-project.org/package=safeBinaryRegression}

Kosmidis I, Firth D (2020). Jeffreys-prior penalty, finiteness
and shrinkage in binomial-response generalized linear
models. *Biometrika* \doi{10.1093/biomet/asaa052}
}
\seealso{
\code{\link{brglm_fit}}, \code{\link{glm.fit}} and \code{\link{glm}}
}
\author{
Ioannis Kosmidis [aut, cre] \email{ioannis.kosmidis@warwick.ac.uk}, Kjell Konis [ctb] \email{kjell.konis@me.com}
}
