% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalcoef.R
\name{marginalcoef}
\alias{marginalcoef}
\title{Marginal Coefficients from a 'brms' Model}
\usage{
marginalcoef(
  object,
  summarize = TRUE,
  posterior = FALSE,
  index,
  backtrans = c("response", "linear", "identity", "invlogit", "exp", "square",
    "inverse"),
  k = 100L,
  ...
)
}
\arguments{
\item{object}{A fitted brms model object that includes random effects. Required.}

\item{summarize}{A logical value, whether or not to
calculate summaries of the posterior predictions.
Defaults to \code{TRUE}.}

\item{posterior}{A logical value whether or not to
save and return the posterior samples. Defaults
to \code{FALSE} as the assumption is a typical
use case is to return the summaries only.}

\item{index}{An optional integer vector, giving the posterior draws
to be used in the calculations. If omitted, defaults to all
posterior draws.}

\item{backtrans}{A character string indicating the type of
back transformation to be applied. Can be one of
\dQuote{response} meaning to use the response scale,
\dQuote{linear} or \dQuote{identity} meaning to use the linear predictor scale,
or a specific back transformation desired, from a possible list of
\dQuote{invlogit}, \dQuote{exp}, \dQuote{square}, or \dQuote{inverse}.
Custom back transformations should only be needed if, for example,
the outcome variable was transformed prior to fitting the model.}

\item{k}{An integer providing the number of random draws to use for
integrating out the random effects. Only relevant when \code{effects}
is \dQuote{integrateoutRE}.}

\item{...}{Additional arguments passed to \code{fitted()}}
}
\value{
A list with \code{Summary} and \code{Posterior}.
Some of these may be \code{NULL} depending on the arguments used.
}
\description{
Calculate marginal coefficients from a \code{brms}
generalized linear mixed model using the method proposed by Hedeker (2018).
}
\references{
Hedeker, D., du Toit, S. H., Demirtas, H. & Gibbons, R. D. (2018)
\doi{10.1111/biom.12707}
\dQuote{A note on marginalization of regression parameters from mixed models of binary outcomes}
}
