% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holmans_triangle.R
\name{tritext}
\alias{tritext}
\title{Plot text within a Holmans triangle}
\usage{
tritext(x, labels, ...)
}
\arguments{
\item{x}{A matrix with three rows, each column being a trinomial distribution.}

\item{labels}{A vector of character strings, with length equal to the number of columns of \code{x}.}

\item{...}{Passed to \code{\link[graphics:text]{graphics::text()}}.}
}
\value{
Text is plotted at the (x,y) coordinates of the points.
}
\description{
Plot text within a Holmans triangle (an equilateral triangle used to depict
trinomial distributions).
}
\details{
Plot of an equilateral triangle, in order to depict trinomial
distributions.  A trinomial distribution (that is, a trio of
non-negative numbers that add to 1) is equated to a point in the
triangle through the distances to the three sides.  This makes use of
the fact that for any point in an equilateral triangle, the sum of the
distances to the three sides is constant.
First use \code{\link[=triplot]{triplot()}} to first plot the equilateral triangle.
}
\examples{
triplot()
x <- cbind(c(0.25, 0.5, 0.25), c(1/3, 1/3, 1/3))
tripoints(x, lwd=2, pch=21, bg="lightblue")
xp <- x + c(0.02, 0, -0.02)
tritext(xp, c("(1/4,1/2,1/4)", "(1/3,1/3,1/3)"), adj=c(0, 0.5))

}
\seealso{
\code{\link[=triplot]{triplot()}}, \code{\link[=trilines]{trilines()}},
\code{\link[=triarrow]{triarrow()}}, \code{\link[=tripoints]{tripoints()}}
}
\keyword{hplot}
