% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_inputs.R
\name{add_inputs}
\alias{add_inputs}
\title{Create multiple textInput functions in Shiny}
\usage{
add_inputs(numeric_input, label, value)
}
\arguments{
\item{numeric_input}{Name of numerical input that controls the number of items to add.}

\item{label}{Label of new textInput.}

\item{value}{Value of new textInput.}
}
\value{
Returns textInput for use in the \code{shiny_emissions()} function.
}
\description{
For use in the \code{shiny_emissions()} function. Adding an unknown quantity of textInputs.
}
\examples{
if(interactive()) {
ui <- shinydashboard::dashboardPage(header = shinydashboard::dashboardHeader(),
                                    sidebar = shinydashboard::dashboardSidebar(),
                                    shinydashboard::dashboardBody(
                                    shiny::fluidRow(
                                    shiny::column(12, align = "left",
                                    shiny::splitLayout(shinydashboard::box(width = NULL,
                                    shiny::numericInput("newbox_add",
                                                        "Number of new boxes:",
                                                        value = 0, min = 0),
                                    shiny::uiOutput("newbox_input")))))))
server <- function(input, output) {
  K_plane <- shiny::reactive({ input$newbox_add })
  output$newbox_input <- shiny::renderUI({ add_inputs(numeric_input = K_plane(),
                                                      label = "New Box:",
                                                      value = "textbox") })
}
shiny::shinyApp(ui, server)
}
}
