% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_value_box.R
\name{gg_value_box}
\alias{gg_value_box}
\title{Create a Value Box for Reports}
\usage{
gg_value_box(values, information, icons)
}
\arguments{
\item{values}{A vector of numeric values to be displayed in the value box.}

\item{information}{A vector of strings providing information or labels for the values.}

\item{icons}{A vector of Font Awesome unicode symbols to be displayed as icons.}
}
\value{
A \code{ggplot2} object with a value box for report use.
}
\description{
This function creates a value box for use in reports.
}
\details{
This function creates a value box with customizable values, information, and icons.
The function takes inputs for the values, information, icons, and color of the value box.
The values and information are provided as vectors, while the icons are specified using
Font Awesome unicode symbols. The color of the value box can be customized using a factor
variable. The resulting value box is a \code{ggplot2} object that can be further customized or
combined with other plots or elements in a report.
}
\examples{
# Create a value box with custom values and icons
gg_value_box(
  values = c(100, 500, 1000),
  information = c("Sales", "Revenue", "Customers"),
  icons = c("\U0000f155", "\U0000f155", "\U0000f0f7")
)
}
\references{
Modified from Stack Overflow post: https://stackoverflow.com/questions/47105282/valuebox-like-function-for-static-reports
}
