% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear.R
\name{nonlinear_2d}
\alias{nonlinear_2d}
\title{Generate points on a nonlinear 2D manifold}
\usage{
nonlinear_2d(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The number of points to generate.}

\item{num_noise}{The number of noise dimensions to add to the generated points.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the generated points on the nonlinear 2D manifold.
}
\description{
This function generates points on a nonlinear 2D manifold based on a given equation.
}
\examples{
set.seed(20240412)
nonlinear_points <- nonlinear_2d(
  n = 100, num_noise = 2, min_n = -0.01,
  max_n = 0.01
)

}
