% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBorders.R
\name{getBorders}
\alias{getBorders}
\title{Extract SpatialPolygonsDataFrame Borders}
\usage{
getBorders(spdf, spdfid = NULL, tol = 1)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{tol}{tolerance to detect contiguity (in map units). You may 
not want to change this parameter.}
}
\value{
A SpatialLinesDataFrame of borders is returned. This object has three 
id fields: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract borders between SpatialPolygonsDataFrame units.
}
\note{
This function uses the rgeos package.
}
\examples{
data(nuts2006)
# Get units borders
nuts0.contig.spdf <- getBorders(nuts0.spdf)
# Random colors
nuts0.contig.spdf$col <- sample(x = rainbow(length(nuts0.contig.spdf)))
# Plot Countries
plot(nuts0.spdf, border = NA, col = "grey60")
# Plot borders
plot(nuts0.contig.spdf, col = nuts0.contig.spdf$col, lwd = 3, add = TRUE)
}
\seealso{
\link{discLayer}
}

