% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet02.R
\docType{data}
\name{aet02_label}
\alias{aet02_label}
\alias{aet02_main}
\alias{aet02_pre}
\alias{aet02_post}
\alias{aet02}
\title{\code{AET02} Table 1 (Default) Adverse Events by System Organ Class and Preferred Term Table 1.}
\format{
An object of class \code{character} of length 2.

An object of class \code{chevron_t} of length 1.
}
\usage{
aet02_label

aet02_main(
  adam_db,
  arm_var = "ACTARM",
  row_split_var = "AEBODSYS",
  lbl_overall = NULL,
  summary_labels = list(all = aet02_label, TOTAL = c(nonunique =
    "Overall total number of events")),
  ...
)

aet02_pre(adam_db, row_split_var = "AEBODSYS", ...)

aet02_post(tlg, row_split_var = "AEBODSYS", prune_0 = TRUE, ...)

aet02
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{summary_labels}{(\code{list}) of summarize labels. See details.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{AET02} table provides an overview of the number of subjects experiencing adverse events and the number of advert
events categorized by Body System and Dictionary-Derived Term.
}
\details{
\itemize{
\item Numbers represent absolute numbers of subject and fraction of \code{N}, or absolute number of event when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort Dictionary-Derived Code (\code{AEDECOD}) by highest overall frequencies.
\item Missing values in \code{AEBODSYS}, and \code{AEDECOD} are labeled by \verb{No Coding Available}.
\code{summary_labels} is used to control the summary for each level. If "all" is used, then each split will have that
summary statistic with the labels. One special case is "TOTAL", this is for the overall population.
}
}
\section{Functions}{
\itemize{
\item \code{aet02_label}: Default labels

\item \code{aet02_main()}: Main TLG function

\item \code{aet02_pre()}: Preprocessing

\item \code{aet02_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adae} table with the columns \code{"AEBODSYS"} and \code{"AEDECOD"}.
}
}
\examples{
run(aet02, syn_data)
}
\keyword{datasets}
