% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmpt01.R
\docType{data}
\name{rmpt01_main}
\alias{rmpt01_main}
\alias{rmpt01_pre}
\alias{rmpt01_post}
\alias{rmpt01}
\title{\code{RMPT01}Duration of Exposure for Risk Management Plan Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
rmpt01_main(
  adam_db,
  summaryvars = "AVALCAT1",
  show_tot = TRUE,
  row_split_var = NULL,
  col_split_var = NULL,
  overall_col_lbl = NULL,
  ...
)

rmpt01_pre(adam_db, summaryvars = "AVALCAT1", ...)

rmpt01_post(tlg, prune_0 = FALSE, ...)

rmpt01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{summaryvars}{(\code{string}) variables to be analyzed. The label attribute of the corresponding columns in \code{adex}
table of \code{adam_db} is used as label.}

\item{show_tot}{(\code{flag}) whether to display the cumulative total.}

\item{row_split_var}{(\code{string}) the name of the column that containing variable to split exposure by.}

\item{col_split_var}{(\code{string}) additional column splitting variable.}

\item{overall_col_lbl}{(\code{string}) name of the overall column. If \code{NULL}, no overall level is added.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{RMPT01} table provides an overview of duration of exposure.
}
\details{
\itemize{
\item Person time is the sum of exposure across all patients.
\item Summary statistics are by default based on the number of patients in the corresponding \code{N} row
(number of non-missing values).
\item Does not remove zero-count rows unless overridden with \code{prune_0 = TRUE}.
}
}
\section{Functions}{
\itemize{
\item \code{rmpt01_main()}: Main TLG function

\item \code{rmpt01_pre()}: Preprocessing

\item \code{rmpt01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adex} table with \code{"AVAL"} and the columns specified by \code{summaryvars}.
}
}
\examples{
run(rmpt01, syn_data, col_split_var = "SEX")
}
\keyword{datasets}
