% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{std_listing}
\alias{std_listing}
\title{Standard Main Listing Function}
\usage{
std_listing(
  adam_db,
  dataset,
  key_cols,
  disp_cols,
  split_into_pages_by_var,
  unique_rows = FALSE,
  ...
)
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{key_cols}{(\code{character}) names of columns that should be treated as key columns when rendering the listing.
Key columns allow you to group repeat occurrences.}

\item{disp_cols}{(\code{character}) names of non-key columns which should be displayed when the listing is rendered.}

\item{split_into_pages_by_var}{(\code{character} or \code{NULL}) the name of the variable to split the listing by.}

\item{unique_rows}{(\code{flag}) whether to keep only unique rows in listing.}

\item{...}{additional arguments passed to \code{\link[rlistings:listings]{rlistings::as_listing}}.}
}
\value{
the main function returns an \code{rlistings} or a \code{list} object.
}
\description{
Standard Main Listing Function
}
\keyword{internal}
