# cfbt01 functions with default argument value return expected result with test data

    Code
      cat(export_as_txt(res, lpp = 100))
    Output
      
      Parameter: Diastolic Blood Pressure
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                94.385 (17.067)        NE (NE)       106.381 (20.586)       NE (NE)     
          Median                        94.933              NE              111.133               NE       
          Min - Max                 55.71 - 122.00        NE - NE        60.21 - 131.91        NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                96.133 (22.458)                      108.111 (15.074)                   
          Median                        93.328                              108.951                        
          Min - Max                 60.58 - 136.59                       83.44 - 131.62                    
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                98.977 (21.359)    2.844 (28.106)    104.110 (16.172)   -4.001 (21.867) 
          Median                        92.447            -4.066            107.703             3.227      
          Min - Max                 67.55 - 130.37    -32.82 - 47.68     70.91 - 132.89     -52.94 - 28.63 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                99.758 (14.477)    3.626 (21.189)    97.473 (17.296)    -10.638 (20.831)
          Median                       101.498             1.731             99.501             -9.727     
          Min - Max                 71.98 - 122.81    -39.50 - 47.57     53.80 - 125.81     -55.15 - 25.26 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                99.101 (26.109)    2.968 (34.327)    91.984 (16.925)    -16.127 (21.881)
          Median                       101.146            -0.271             91.244            -14.384     
          Min - Max                 47.68 - 162.22    -47.87 - 76.64     67.80 - 119.72     -53.06 - 22.52 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                103.400 (22.273)   7.267 (30.740)    96.467 (19.451)    -11.644 (25.922)
          Median                        98.168             2.510             97.385            -16.793     
          Min - Max                 63.09 - 148.25    -38.43 - 61.90     63.35 - 131.57     -57.11 - 48.13 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                93.222 (18.536)    -2.911 (28.873)   97.890 (20.701)    -10.221 (27.593)
          Median                        90.799            -3.385             99.049            -11.319     
          Min - Max                 63.55 - 139.11    -48.63 - 47.35     69.47 - 137.64     -54.38 - 37.85 
      \s\n
      Parameter: Diastolic Blood Pressure
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                106.468 (12.628)       NE (NE)     
          Median                       108.359               NE       
          Min - Max                 83.29 - 127.17        NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                103.149 (19.752)                   
          Median                       102.849                        
          Min - Max                 66.05 - 136.55                    
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                100.826 (19.027)   -2.323 (25.018) 
          Median                       103.058             -2.476     
          Min - Max                 70.04 - 128.68     -55.15 - 41.81 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                94.272 (16.961)    -8.877 (27.229) 
          Median                        96.789            -10.155     
          Min - Max                 63.45 - 117.47     -73.10 - 46.54 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                94.586 (13.560)    -8.563 (21.713) 
          Median                        98.398            -16.075     
          Min - Max                 73.50 - 115.43     -37.90 - 32.66 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                108.338 (18.417)    5.189 (21.881) 
          Median                       107.555             7.966      
          Min - Max                 68.78 - 132.52     -33.96 - 41.50 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                95.317 (16.401)    -7.832 (19.827) 
          Median                        93.876             -4.665     
          Min - Max                 71.91 - 138.54     -44.47 - 29.11 
      \s\n
      Parameter: Pulse Rate
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                79.848 (13.356)        NE (NE)       82.170 (18.331)        NE (NE)     
          Median                        78.706              NE               78.554               NE       
          Min - Max                 48.94 - 102.62        NE - NE        55.11 - 122.56        NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                81.896 (10.297)                      85.584 (14.663)                    
          Median                        81.733                               80.261                        
          Min - Max                 62.38 - 102.46                       63.62 - 115.60                    
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                73.932 (16.268)    -7.963 (15.197)   81.615 (15.744)    -3.969 (19.689) 
          Median                        77.008            -7.885             82.358             -0.486     
          Min - Max                 37.37 - 97.36     -35.04 - 21.67     53.97 - 102.01     -61.63 - 26.24 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                77.164 (14.067)    -4.731 (19.872)    80.645 (7.774)    -4.939 (17.465) 
          Median                        80.424            -7.412             80.107             -9.642     
          Min - Max                 51.40 - 102.39    -40.41 - 36.25     66.90 - 92.92      -38.18 - 20.90 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                83.812 (12.679)    1.916 (16.213)    83.354 (18.590)    -2.230 (19.940) 
          Median                        87.736             2.160             86.412             3.513      
          Min - Max                 46.95 - 102.74    -28.74 - 25.43     43.66 - 107.29     -29.19 - 43.67 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                74.829 (12.786)    -7.067 (16.097)   79.151 (12.081)    -6.433 (17.236) 
          Median                        76.227            -5.506             78.650             -8.084     
          Min - Max                 48.95 - 95.54     -38.03 - 13.57     54.79 - 105.87     -35.78 - 25.73 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                79.792 (11.206)    -2.104 (13.269)   87.561 (17.865)     1.977 (19.814) 
          Median                        82.997            -0.210             82.023             3.049      
          Min - Max                 55.68 - 92.89     -24.05 - 20.22     65.33 - 128.99     -50.27 - 32.78 
      \s\n
      Parameter: Pulse Rate
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                79.679 (15.350)        NE (NE)     
          Median                        76.903               NE       
          Min - Max                 59.79 - 110.03        NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                77.107 (14.159)                    
          Median                        78.950                        
          Min - Max                 52.36 - 96.61                     
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                76.625 (15.814)    -0.482 (20.797) 
          Median                        79.731             8.488      
          Min - Max                 48.84 - 104.77     -37.33 - 28.64 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                79.044 (13.193)     1.937 (15.609) 
          Median                        74.361             5.695      
          Min - Max                 65.32 - 111.55     -22.38 - 27.05 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                75.924 (10.045)    -1.183 (16.167) 
          Median                        74.720             0.057      
          Min - Max                 61.17 - 95.54      -27.66 - 27.57 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                77.979 (14.535)     0.872 (20.465) 
          Median                        78.231             2.808      
          Min - Max                 51.48 - 104.71     -33.19 - 44.14 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                84.617 (17.937)     7.510 (21.612) 
          Median                        84.022             12.943     
          Min - Max                 34.86 - 110.03     -42.18 - 41.69 
      \s\n
      Parameter: Respiratory Rate
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                 15.043 (3.455)        NE (NE)        16.400 (3.741)        NE (NE)     
          Median                        15.743              NE               16.303               NE       
          Min - Max                  5.75 - 20.24         NE - NE         9.79 - 25.68         NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                 13.353 (5.061)                       16.270 (5.086)                    
          Median                        13.202                               15.898                        
          Min - Max                  4.68 - 23.59                         9.51 - 25.27                     
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                 15.832 (5.336)     2.478 (6.550)     14.301 (4.143)     -1.969 (6.549) 
          Median                        13.364             3.245             13.556             -0.768     
          Min - Max                  7.24 - 24.69     -12.99 - 14.74      7.80 - 21.64      -14.50 - 8.50  
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 15.195 (5.532)     1.842 (6.646)     16.335 (6.402)     0.065 (8.770)  
          Median                        15.137             3.348             15.710             0.144      
          Min - Max                  2.50 - 24.34      -15.54 - 9.87      8.02 - 26.40      -17.25 - 14.68 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 12.757 (6.587)    -0.597 (5.529)     16.806 (5.518)     0.537 (8.174)  
          Median                        11.334             1.128             17.496             -0.116     
          Min - Max                  0.62 - 22.74      -12.26 - 5.99      6.06 - 26.22      -17.50 - 11.77 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 14.950 (4.443)     1.597 (4.795)     14.464 (4.510)     -1.805 (6.965) 
          Median                        15.727             2.893             13.246             -0.655     
          Min - Max                  7.98 - 21.41      -8.31 - 7.94       5.60 - 20.66      -14.26 - 11.00 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 13.632 (6.374)     0.279 (8.063)     19.383 (5.590)     3.113 (6.914)  
          Median                        13.068             0.442             18.527             1.760      
          Min - Max                  2.34 - 24.54      -17.58 - 9.42     11.62 - 28.62      -6.74 - 18.02  
      \s\n
      Parameter: Respiratory Rate
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                 15.781 (4.800)        NE (NE)     
          Median                        16.645               NE       
          Min - Max                  7.32 - 21.56         NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                 15.339 (3.052)                    
          Median                        15.491                        
          Min - Max                 10.90 - 20.89                     
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                 14.673 (6.117)     -0.666 (7.274) 
          Median                        16.835             2.369      
          Min - Max                  1.65 - 20.89      -15.56 - 8.01  
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                 16.777 (5.546)     1.439 (5.186)  
          Median                        17.770             1.783      
          Min - Max                  2.57 - 22.56      -10.09 - 9.60  
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                 14.975 (5.562)     -0.364 (6.029) 
          Median                        15.340             -0.615     
          Min - Max                  4.81 - 22.60      -10.55 - 10.78 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                 14.016 (8.365)     -1.323 (9.534) 
          Median                        15.704             0.213      
          Min - Max                  1.00 - 27.54      -14.36 - 13.97 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                 15.623 (5.417)     0.284 (7.141)  
          Median                        15.202             -0.157     
          Min - Max                  4.46 - 29.18      -11.90 - 13.69 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                154.073 (33.511)       NE (NE)       157.840 (34.393)       NE (NE)     
          Median                       156.169              NE              161.670               NE       
          Min - Max                 78.31 - 210.70        NE - NE        79.76 - 210.40        NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                145.925 (28.231)                     152.007 (28.664)                   
          Median                       142.705                              157.698                        
          Min - Max                 85.21 - 195.68                       98.90 - 194.62                    
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                156.509 (21.097)   10.584 (34.598)   147.480 (33.473)   -4.527 (48.895) 
          Median                       160.711             5.802            155.030             2.758      
          Min - Max                126.84 - 185.53    -53.28 - 91.52     85.22 - 189.88     -77.34 - 90.98 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                144.202 (33.676)   -1.723 (27.067)   136.892 (30.178)   -15.115 (37.794)
          Median                       144.253             5.325            142.679            -14.083     
          Min - Max                 62.56 - 203.66    -53.89 - 44.16     70.34 - 174.27     -83.07 - 62.39 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                154.887 (35.374)   8.962 (38.455)    149.761 (28.944)   -2.247 (44.835) 
          Median                       158.938            17.191            155.044             -1.796     
          Min - Max                112.32 - 218.83    -47.28 - 96.18     84.42 - 192.92    -110.20 - 94.02 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                150.159 (32.249)   4.234 (32.965)    156.043 (22.863)    4.036 (42.494) 
          Median                       145.506             3.754            149.094            -10.000     
          Min - Max                 69.37 - 210.43    -89.16 - 54.32    113.57 - 195.10     -71.44 - 77.75 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                155.964 (30.945)   10.039 (42.252)   156.387 (35.274)    4.380 (51.782) 
          Median                       158.142             1.448            164.552             7.060      
          Min - Max                110.61 - 212.47    -53.91 - 90.45     63.28 - 198.79    -131.34 - 86.84 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                152.407 (22.311)       NE (NE)     
          Median                       149.556               NE       
          Min - Max                108.21 - 184.88        NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                154.173 (26.317)                   
          Median                       155.282                        
          Min - Max                 86.65 - 192.68                    
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                143.319 (30.759)   -10.854 (34.553)
          Median                       145.548             -5.636     
          Min - Max                 90.37 - 191.58     -65.71 - 49.04 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                148.622 (27.088)   -5.551 (44.670) 
          Median                       147.102            -11.512     
          Min - Max                108.82 - 200.23    -69.54 - 113.59 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                150.460 (21.352)   -3.712 (37.984) 
          Median                       156.505             -7.606     
          Min - Max                 94.70 - 180.41     -74.91 - 72.74 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                145.714 (22.980)   -8.458 (33.175) 
          Median                       150.797            -14.432     
          Min - Max                106.91 - 188.09     -41.95 - 65.16 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                143.592 (33.170)   -10.581 (44.799)
          Median                       148.501             -2.385     
          Min - Max                 92.18 - 191.05     -78.77 - 64.35 
      \s\n
      Parameter: Temperature
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                 36.273 (1.136)        NE (NE)        36.731 (1.142)        NE (NE)     
          Median                        36.131              NE               36.506               NE       
          Min - Max                 34.07 - 38.59         NE - NE        34.97 - 39.04         NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                 36.763 (1.167)                       36.707 (1.528)                    
          Median                        36.694                               37.144                        
          Min - Max                 35.08 - 38.72                        33.65 - 38.92                     
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                 36.280 (0.543)    -0.483 (1.022)     36.292 (1.378)     -0.415 (1.957) 
          Median                        36.194            -0.609             36.451             -0.344     
          Min - Max                 35.37 - 37.06      -2.07 - 1.11      33.03 - 38.47       -4.72 - 2.24  
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 37.090 (1.136)     0.328 (1.647)     36.577 (1.291)     -0.130 (1.799) 
          Median                        37.138             0.153             36.113             0.300      
          Min - Max                 34.44 - 38.95      -2.34 - 2.85      34.86 - 39.29       -3.52 - 2.55  
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 36.725 (1.003)    -0.038 (1.441)     36.546 (1.008)     -0.161 (1.701) 
          Median                        36.616             0.029             36.378             -0.368     
          Min - Max                 35.24 - 38.26      -3.25 - 2.34      35.08 - 38.17       -2.59 - 4.13  
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 36.545 (1.070)    -0.218 (1.859)     36.574 (1.024)     -0.133 (1.994) 
          Median                        36.299            -0.701             36.546             -0.436     
          Min - Max                 34.87 - 39.00      -3.85 - 3.10      34.77 - 38.98       -2.74 - 4.07  
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                 37.038 (0.918)     0.275 (1.334)     36.823 (1.247)     0.117 (1.387)  
          Median                        36.945             0.346             36.839             -0.476     
          Min - Max                 35.71 - 38.45      -2.78 - 2.77      34.69 - 38.91       -1.76 - 3.06  
      \s\n
      Parameter: Temperature
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                 36.565 (1.112)        NE (NE)     
          Median                        36.681               NE       
          Min - Max                 35.30 - 38.90         NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                 36.383 (0.963)                    
          Median                        36.496                        
          Min - Max                 34.71 - 37.92                     
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                 36.848 (0.936)     0.465 (1.458)  
          Median                        36.973             0.399      
          Min - Max                 35.28 - 38.18       -1.44 - 2.99  
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                 36.620 (1.077)     0.237 (1.595)  
          Median                        36.519             0.690      
          Min - Max                 34.89 - 38.33       -3.02 - 2.47  
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                 36.697 (0.694)     0.314 (1.312)  
          Median                        36.679             0.841      
          Min - Max                 35.14 - 37.64       -2.77 - 2.63  
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                 36.738 (0.760)     0.355 (0.872)  
          Median                        36.585             0.352      
          Min - Max                 35.29 - 38.24       -0.91 - 2.14  
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                 36.716 (1.056)     0.333 (1.344)  
          Median                        36.404             0.500      
          Min - Max                 35.26 - 38.64       -1.83 - 3.72  
      \s\n
      Parameter: Weight
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                81.827 (23.644)        NE (NE)       61.563 (19.272)        NE (NE)     
          Median                        80.182              NE               62.147               NE       
          Min - Max                 40.48 - 133.35        NE - NE        23.27 - 92.39         NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                76.532 (15.588)                      70.870 (12.845)                    
          Median                        71.929                               66.405                        
          Min - Max                 56.24 - 102.43                       54.36 - 96.85                     
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                71.171 (19.805)    -5.360 (23.082)   69.872 (17.781)    -0.998 (20.176) 
          Median                        65.106            -6.780             70.971             -2.628     
          Min - Max                 47.03 - 123.95    -49.07 - 40.63     30.55 - 93.75      -35.86 - 28.87 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                80.484 (18.937)    3.952 (22.123)    72.940 (20.302)     2.070 (17.837) 
          Median                        75.792             3.284             71.374             3.396      
          Min - Max                 44.83 - 112.37    -36.68 - 35.07     35.00 - 106.69     -32.41 - 26.17 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                68.100 (15.095)    -8.431 (18.100)   71.883 (18.376)     1.013 (22.760) 
          Median                        66.175            -7.353             76.267             3.928      
          Min - Max                 30.53 - 91.08     -46.15 - 29.48     20.87 - 95.04      -43.57 - 29.54 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                73.294 (18.861)    -3.238 (18.094)   71.553 (17.090)     0.683 (16.404) 
          Median                        76.829            -0.941             70.705             -1.527     
          Min - Max                 24.32 - 98.14     -44.46 - 18.39     43.61 - 107.47     -26.14 - 43.89 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                66.719 (15.750)    -9.812 (26.403)   68.162 (15.787)    -2.708 (20.179) 
          Median                        64.046            -5.370             67.480             -1.537     
          Min - Max                 33.02 - 95.14     -69.42 - 26.72     45.71 - 102.63     -36.52 - 30.47 
      \s\n
      Parameter: Weight
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                64.923 (16.678)        NE (NE)     
          Median                        62.745               NE       
          Min - Max                 26.70 - 94.66         NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                71.676 (16.922)                    
          Median                        68.883                        
          Min - Max                 27.15 - 107.89                    
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                74.799 (13.706)     3.123 (21.964) 
          Median                        71.374             4.336      
          Min - Max                 53.19 - 96.54      -32.10 - 51.00 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                67.267 (19.187)    -4.409 (25.986) 
          Median                        60.651             -5.246     
          Min - Max                 35.56 - 102.05     -67.52 - 33.50 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                70.442 (21.914)    -1.234 (25.307) 
          Median                        72.649             5.691      
          Min - Max                 31.36 - 101.13     -45.69 - 32.28 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                77.447 (21.174)     5.771 (25.479) 
          Median                        86.161             19.614     
          Min - Max                 41.60 - 112.40     -40.90 - 35.30 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                65.688 (23.847)    -5.988 (35.176) 
          Median                        71.788             -7.456     
          Min - Max                 12.04 - 114.55     -71.68 - 87.41 

# cfbt01 can handle n = 0 and outputs NE instead of infs and NAs

    Code
      cat(export_as_txt(res, lpp = 100))
    Output
      
      Parameter: Diastolic Blood Pressure
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                94.385 (17.067)        NE (NE)       106.381 (20.586)       NE (NE)     
          Median                        94.933              NE              111.133               NE       
          Min - Max                 55.71 - 122.00        NE - NE        60.21 - 131.91        NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                96.133 (22.458)                      108.111 (15.074)                   
          Median                        93.328                              108.951                        
          Min - Max                 60.58 - 136.59                       83.44 - 131.62                    
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                98.977 (21.359)    2.844 (28.106)    104.110 (16.172)   -4.001 (21.867) 
          Median                        92.447            -4.066            107.703             3.227      
          Min - Max                 67.55 - 130.37    -32.82 - 47.68     70.91 - 132.89     -52.94 - 28.63 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                99.758 (14.477)    3.626 (21.189)    97.473 (17.296)    -10.638 (20.831)
          Median                       101.498             1.731             99.501             -9.727     
          Min - Max                 71.98 - 122.81    -39.50 - 47.57     53.80 - 125.81     -55.15 - 25.26 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                99.101 (26.109)    2.968 (34.327)    91.984 (16.925)    -16.127 (21.881)
          Median                       101.146            -0.271             91.244            -14.384     
          Min - Max                 47.68 - 162.22    -47.87 - 76.64     67.80 - 119.72     -53.06 - 22.52 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                103.400 (22.273)   7.267 (30.740)    96.467 (19.451)    -11.644 (25.922)
          Median                        98.168             2.510             97.385            -16.793     
          Min - Max                 63.09 - 148.25    -38.43 - 61.90     63.35 - 131.57     -57.11 - 48.13 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                93.222 (18.536)    -2.911 (28.873)   97.890 (20.701)    -10.221 (27.593)
          Median                        90.799            -3.385             99.049            -11.319     
          Min - Max                 63.55 - 139.11    -48.63 - 47.35     69.47 - 137.64     -54.38 - 37.85 
      \s\n
      Parameter: Diastolic Blood Pressure
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                106.468 (12.628)       NE (NE)     
          Median                       108.359               NE       
          Min - Max                 83.29 - 127.17        NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                103.149 (19.752)                   
          Median                       102.849                        
          Min - Max                 66.05 - 136.55                    
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                100.826 (19.027)   -2.323 (25.018) 
          Median                       103.058             -2.476     
          Min - Max                 70.04 - 128.68     -55.15 - 41.81 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                94.272 (16.961)    -8.877 (27.229) 
          Median                        96.789            -10.155     
          Min - Max                 63.45 - 117.47     -73.10 - 46.54 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                94.586 (13.560)    -8.563 (21.713) 
          Median                        98.398            -16.075     
          Min - Max                 73.50 - 115.43     -37.90 - 32.66 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                108.338 (18.417)    5.189 (21.881) 
          Median                       107.555             7.966      
          Min - Max                 68.78 - 132.52     -33.96 - 41.50 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                95.317 (16.401)    -7.832 (19.827) 
          Median                        93.876             -4.665     
          Min - Max                 71.91 - 138.54     -44.47 - 29.11 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ———————————————————————————————————————————————————————————————————————————————————————————————————
                                               A: Drug X                            B: Placebo             
                                                        Change from                          Change from   
                                    Value at Visit       Baseline        Value at Visit        Baseline    
        Analysis Visit                  (N=15)            (N=15)             (N=15)             (N=15)     
        ———————————————————————————————————————————————————————————————————————————————————————————————————
        SCREENING                                                                                          
          n                               15                 0                 15                 0        
          Mean (SD)                154.073 (33.511)       NE (NE)       157.840 (34.393)       NE (NE)     
          Median                       156.169              NE              161.670               NE       
          Min - Max                 78.31 - 210.70        NE - NE        79.76 - 210.40        NE - NE     
        BASELINE                                                                                           
          n                               15                                   15                          
          Mean (SD)                145.925 (28.231)                     152.007 (28.664)                   
          Median                       142.705                              157.698                        
          Min - Max                 85.21 - 195.68                       98.90 - 194.62                    
        WEEK 1 DAY 8                                                                                       
          n                               15                15                 15                 15       
          Mean (SD)                156.509 (21.097)   10.584 (34.598)   147.480 (33.473)   -4.527 (48.895) 
          Median                       160.711             5.802            155.030             2.758      
          Min - Max                126.84 - 185.53    -53.28 - 91.52     85.22 - 189.88     -77.34 - 90.98 
        WEEK 2 DAY 15                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                144.202 (33.676)   -1.723 (27.067)   136.892 (30.178)   -15.115 (37.794)
          Median                       144.253             5.325            142.679            -14.083     
          Min - Max                 62.56 - 203.66    -53.89 - 44.16     70.34 - 174.27     -83.07 - 62.39 
        WEEK 3 DAY 22                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                154.887 (35.374)   8.962 (38.455)    149.761 (28.944)   -2.247 (44.835) 
          Median                       158.938            17.191            155.044             -1.796     
          Min - Max                112.32 - 218.83    -47.28 - 96.18     84.42 - 192.92    -110.20 - 94.02 
        WEEK 4 DAY 29                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                150.159 (32.249)   4.234 (32.965)    156.043 (22.863)    4.036 (42.494) 
          Median                       145.506             3.754            149.094            -10.000     
          Min - Max                 69.37 - 210.43    -89.16 - 54.32    113.57 - 195.10     -71.44 - 77.75 
        WEEK 5 DAY 36                                                                                      
          n                               15                15                 15                 15       
          Mean (SD)                155.964 (30.945)   10.039 (42.252)   156.387 (35.274)    4.380 (51.782) 
          Median                       158.142             1.448            164.552             7.060      
          Min - Max                110.61 - 212.47    -53.91 - 90.45     63.28 - 198.79    -131.34 - 86.84 
      \s\n
      Parameter: Systolic Blood Pressure
      
        ——————————————————————————————————————————————————————————————
                                             C: Combination           
                                                        Change from   
                                    Value at Visit        Baseline    
        Analysis Visit                  (N=15)             (N=15)     
        ——————————————————————————————————————————————————————————————
        SCREENING                                                     
          n                               15                 0        
          Mean (SD)                152.407 (22.311)       NE (NE)     
          Median                       149.556               NE       
          Min - Max                108.21 - 184.88        NE - NE     
        BASELINE                                                      
          n                               15                          
          Mean (SD)                154.173 (26.317)                   
          Median                       155.282                        
          Min - Max                 86.65 - 192.68                    
        WEEK 1 DAY 8                                                  
          n                               15                 15       
          Mean (SD)                143.319 (30.759)   -10.854 (34.553)
          Median                       145.548             -5.636     
          Min - Max                 90.37 - 191.58     -65.71 - 49.04 
        WEEK 2 DAY 15                                                 
          n                               15                 15       
          Mean (SD)                148.622 (27.088)   -5.551 (44.670) 
          Median                       147.102            -11.512     
          Min - Max                108.82 - 200.23    -69.54 - 113.59 
        WEEK 3 DAY 22                                                 
          n                               15                 15       
          Mean (SD)                150.460 (21.352)   -3.712 (37.984) 
          Median                       156.505             -7.606     
          Min - Max                 94.70 - 180.41     -74.91 - 72.74 
        WEEK 4 DAY 29                                                 
          n                               15                 15       
          Mean (SD)                145.714 (22.980)   -8.458 (33.175) 
          Median                       150.797            -14.432     
          Min - Max                106.91 - 188.09     -41.95 - 65.16 
        WEEK 5 DAY 36                                                 
          n                               15                 15       
          Mean (SD)                143.592 (33.170)   -10.581 (44.799)
          Median                       148.501             -2.385     
          Min - Max                 92.18 - 191.05     -78.77 - 64.35 

