% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climdex.r
\name{climdex.wsdi}
\alias{climdex.wsdi}
\title{Warm Spell Duration Index}
\usage{
climdex.wsdi(ci, spells.can.span.years = FALSE)
}
\arguments{
\item{ci}{Object of type climdexInput.}

\item{spells.can.span.years}{Whether to allow spells of dry/wet days to span
years.}
}
\value{
A vector containing the value of the index for each year.
}
\description{
This function computes the climdex index WSDI.
}
\details{
This function takes a climdexInput object as input and computes the climdex
index WSDI (Warm Spell Duration Index).

The warm spell duration index is defined as the number of days each year
which are part of a "warm spell". A "warm spell" is defined as a sequence of
6 or more days in which the daily maximum temperature exceeds the 90th
percentile of daily maximum temperature for a 5-day running window
surrounding this day during the baseline period.

The \code{spells.can.span.years} option specifies whether spells can cross
year boundaries -- i.e., span years. The default for this is the same as
fclimdex.
}
\note{
These functions may calculate slightly different results than
fclimdex.

Behaviour of climdex.wsdi and climdex.csdi differ somewhat from fclimdex.
fclimdex considers all days in a warm or cold spell to be part of the year
in which the spell ended.  climdex.wsdi and climdex.csdi split the spell
such that days in each spell are allocated to the separate years in the days
occurred.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create an annual timeseries of the warm spell duration index.
wsdi <- climdex.wsdi(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}},
\code{\link{threshold.exceedance.duration.index}}.
}
\keyword{climate}
\keyword{ts}
