% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_calcPropMissing}
\alias{comparison_calcPropMissing}
\title{Calculate the proportion of missing values in a breech face scan}
\usage{
comparison_calcPropMissing(heightValues)
}
\arguments{
\item{heightValues}{list/tibble column of x3p objects}
}
\value{
a vector of the same length as the input containing the proportion of
missing values in each x3p object's breech face scan.
}
\description{
Calculate the proportion of missing values in a breech face scan
}
\examples{
data(fadul1.1_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = 64) \%>\%
dplyr::mutate(cellPropMissing = comparison_calcPropMissing(heightValues = cellHeightValues))

head(cellTibble)

}
