% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefa_tflm2.R
\name{coefa_tflm2}
\alias{coefa_tflm2}
\title{Trimming factor loading matrices(The cutoff range can be selected(0~1))}
\usage{
coefa_tflm2(x, methodE = c("s", "ls"), cutoff)
}
\arguments{
\item{x}{A list of multiple original factor loading matrices included without
NA.}

\item{methodE}{The methods for trimming multiple factor loading matrices from
the original study."s" and "ls" are two methods of trimming the original factor
loading matrix, which are widely used in coefa studies.The s = Shafer’s(2005)
method; ls = the Loeber and Schmaling’s method(1985).}

\item{cutoff}{The Criteria for trimming factor loadings matrices.}
}
\value{
A list contained those trimmed factor loading matrices.
}
\description{
The function can provide the same effect as the coefa_tflm().The difference
is that its cutoff value has a more flexible optional range (0~1).It should
be noted that the flexible cutoff selection range may cause some problems.
coefa_tflm() is recommended for stable performance
}
\examples{
mx1<-matrix(c(0.1,0.2,0.3,0.4),nrow=2)
mx2<-matrix(c(0.4,0.3,0.2,0.1),nrow=2)
list1<-list(mx1,mx2)
#Trim matrices using the Shafer's method ,cutoff is 0.4.
matrices.tflm<-coefa_tflm2(list1,methodE="s",cutoff=0.4)
}
\references{
Loeber,R., & Schmaling, K. B. (1985). Empirical evidence for overt and covert
patterns of antisocial conduct problems: a metaanalysis. Journal of abnormal
 child psychology, 13(2), 337--353.

Shafer,A. B.(2005). Meta-analysis of the Brief Psychiatric Rating Scale
factor structure. Psychological Assessment, 17(3),324--335.

Shafer,A. B. (2006). Meta-analysis of the factor structures of four depression
 questionnaires: Beck, CES-D, Hamilton, and Zung. Journal of clinical
 psychology, 62(1), 123--146.
}
