% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_data_cor}
\alias{validate_data_cor}
\title{Validate Data for Correlation Analysis}
\usage{
validate_data_cor(
  df = NULL,
  predictors = NULL,
  function_name = "collinear::validate_data_cor()",
  quiet = FALSE
)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{function_name}{(optional, character string) Name of the function performing the check. Default: "collinear::validate_data_cor()"}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
character vector: predictors names
}
\description{
Internal function to assess whether the input arguments \code{df} and \code{predictors} result in data dimensions suitable for pairwise correlation analysis.

If the number of rows in \code{df} is smaller than 10, an error is issued.
}
\seealso{
Other data_validation: 
\code{\link{validate_data_vif}()},
\code{\link{validate_df}()},
\code{\link{validate_encoding_arguments}()},
\code{\link{validate_predictors}()},
\code{\link{validate_preference_order}()},
\code{\link{validate_response}()}
}
\concept{data_validation}
