% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comma-free-call.R
\name{\%(\%}
\alias{\%(\%}
\title{Call a function}
\usage{
fn \%(\% args
}
\arguments{
\item{fn}{A function}

\item{args}{A set of expressions grouped by \code{{ }}}
}
\value{
Whatever \code{fn()} called with \code{args} returns.
}
\description{
This allows you to call a function with expressions for arguments. It is
especially useful for long, multi-line function calls with many arguments
(e.g., a shiny UI definition, an R6 class definition, ...)
}
\details{
This (\verb{\%(\%}) merely performs a syntax transformation, so all the same
semantics with regards to lazy argument evaluation apply. For any
function call, replace \code{(} with \verb{\%(\%} and be free of the need for
commas between arguments in that call.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fn \%(\% \{
  a
  b
  c
\}
}\if{html}{\out{</div>}}

Is syntactically equivalent to writing:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{func(
  a,
  b,
  c
)
}\if{html}{\out{</div>}}
}
\note{
You can produce a missing argument with the special token \verb{,,}, or
\code{foo = `,`} for a named missing arguments (see examples).
}
\examples{
mean \%(\% {
  1:3
  na.rm = TRUE
}

writeLines(c \%(\% {
  "Hello"
  "Goodbye"
})

# setup helper demonstrating missing arguments
fn <- function(x, y) {
  if(missing(y))
    print("y was missing")
  else
    print(y)
}

# How to add a named missing argument
fn \%(\% {
  y = `,`
}

# How to add a positional missing argument
fn \%(\% {
  1
  `,,`
}

fn \%(\% { 1; `,,` }

rm(fn) # cleanup
}
