% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configtype.R
\name{get.config.type}
\alias{get.config.type}
\title{Get config file type retreiving json/ini/yaml or FALSE}
\usage{
get.config.type(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"), ...)
}
\arguments{
\item{file}{File name of configuration file to test. Defaults to the value of
the ‘R_CONFIGFILE_ACTIVE’ environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{...}{Arguments for \code{\link{is.json.file}}, 
\code{\link{is.ini.file}}, \code{\link{is.yaml.file}}, 
\code{\link{is.toml.file}}}
}
\value{
Character json/ini/yaml/toml or 
Logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Get config file type retreiving json/ini/yaml or FALSE
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')
config.yaml <- system.file('extdata', 'config.yaml', package='configr')
config.toml <- system.file('extdata', 'config.toml', package='configr')
get.config.type(file=config.json)
get.config.type(file=config.ini)
get.config.type(file=config.yaml)
get.config.type(file=config.toml)
}
\seealso{
\code{\link{is.json.file}}, 
\code{\link{is.ini.file}}, 
\code{\link{is.yaml.file}}, 
\code{\link{is.toml.file}}
}

