% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs.R
\name{ConnectorFS}
\alias{ConnectorFS}
\title{Connector for file storage}
\description{
The ConnectorFS class is a file storage connector for accessing and manipulating files any file storage solution.
The default implementation includes methods for files stored on local or network drives.
}
\details{
We recommend using the wrapper function \code{\link[=connector_fs]{connector_fs()}} to simplify the process of
creating an object of \link{ConnectorFS} class. It provides a more intuitive and user-friendly
approach to initialize the ConnectorFS class and its associated functionalities.
}
\examples{
# Create file storage connector

folder <- withr::local_tempdir()
cnt <- ConnectorFS$new(folder)
cnt

# You can do the same thing using wrapper function connector_fs()
cnt <- connector_fs(folder)
cnt

# List content
cnt$list_content_cnt()

# Write to the connector
cnt$write_cnt(iris, "iris.rds")

# Check it is there
cnt$list_content_cnt()

# Read the result back
cnt$read_cnt("iris.rds") |>
  head()

}
\section{Super class}{
\code{\link[connector:Connector]{connector::Connector}} -> \code{ConnectorFS}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{path}}{\link{character} Path to the file storage}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConnectorFS-new}{\code{ConnectorFS$new()}}
\item \href{#method-ConnectorFS-download_cnt}{\code{ConnectorFS$download_cnt()}}
\item \href{#method-ConnectorFS-upload_cnt}{\code{ConnectorFS$upload_cnt()}}
\item \href{#method-ConnectorFS-create_directory_cnt}{\code{ConnectorFS$create_directory_cnt()}}
\item \href{#method-ConnectorFS-remove_directory_cnt}{\code{ConnectorFS$remove_directory_cnt()}}
\item \href{#method-ConnectorFS-upload_directory_cnt}{\code{ConnectorFS$upload_directory_cnt()}}
\item \href{#method-ConnectorFS-download_directory_cnt}{\code{ConnectorFS$download_directory_cnt()}}
\item \href{#method-ConnectorFS-tbl_cnt}{\code{ConnectorFS$tbl_cnt()}}
\item \href{#method-ConnectorFS-clone}{\code{ConnectorFS$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="connector" data-topic="Connector" data-id="list_content_cnt"><a href='../../connector/html/Connector.html#method-Connector-list_content_cnt'><code>connector::Connector$list_content_cnt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="connector" data-topic="Connector" data-id="print"><a href='../../connector/html/Connector.html#method-Connector-print'><code>connector::Connector$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="connector" data-topic="Connector" data-id="read_cnt"><a href='../../connector/html/Connector.html#method-Connector-read_cnt'><code>connector::Connector$read_cnt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="connector" data-topic="Connector" data-id="remove_cnt"><a href='../../connector/html/Connector.html#method-Connector-remove_cnt'><code>connector::Connector$remove_cnt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="connector" data-topic="Connector" data-id="write_cnt"><a href='../../connector/html/Connector.html#method-Connector-write_cnt'><code>connector::Connector$write_cnt()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-new}{}}}
\subsection{Method \code{new()}}{
Initializes the connector for file storage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$new(path, extra_class = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{\link{character} Path to the file storage.}

\item{\code{extra_class}}{\link{character} Extra class to assign to the new connector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-download_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-download_cnt}{}}}
\subsection{Method \code{download_cnt()}}{
Download content from the file storage.
See also \link{download_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$download_cnt(name, file = basename(name), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{file}}{\link{character} Path to the file to download to or upload from}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} connector_object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-upload_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-upload_cnt}{}}}
\subsection{Method \code{upload_cnt()}}{
Upload a file to the file storage.
See also \link{upload_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$upload_cnt(file, name = basename(file), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{\link{character} Path to the file to download to or upload from}

\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-create_directory_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-create_directory_cnt}{}}}
\subsection{Method \code{create_directory_cnt()}}{
Create a directory in the file storage.
See also \link{create_directory_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$create_directory_cnt(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} The name of the directory to create}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{ConnectorFS} object of a newly created directory
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-remove_directory_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-remove_directory_cnt}{}}}
\subsection{Method \code{remove_directory_cnt()}}{
Remove a directory from the file storage.
See also \link{remove_directory_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$remove_directory_cnt(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} The name of the directory to remove}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-upload_directory_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-upload_directory_cnt}{}}}
\subsection{Method \code{upload_directory_cnt()}}{
Upload a directory to the file storage.
See also \link{upload_directory_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$upload_directory_cnt(dir, name = basename(dir), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{\link{character} The path to the directory to upload}

\item{\code{name}}{\link{character} The name of the directory to create}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} self.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-download_directory_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-download_directory_cnt}{}}}
\subsection{Method \code{download_directory_cnt()}}{
Download a directory from the file storage.
See also \link{download_directory_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$download_directory_cnt(name, dir = name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} The name of the directory to download}

\item{\code{dir}}{\link{character} The path to the directory to download}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} connector_object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-tbl_cnt"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-tbl_cnt}{}}}
\subsection{Method \code{tbl_cnt()}}{
Use dplyr verbs to interact with the tibble.
See also \link{tbl_cnt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$tbl_cnt(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{\code{...}}{Additional arguments passed to the method for the individual connector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A table object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConnectorFS-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConnectorFS-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConnectorFS$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
