% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-ordered.R
\name{opts_ordered}
\alias{opts_ordered}
\title{Constructive options for class 'ordered'}
\usage{
opts_ordered(
  constructor = c("ordered", "factor", "new_ordered", "next", "integer"),
  ...
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the object, see Details section.}

\item{...}{Additional options used by user defined constructors through the \code{opts} object}
}
\value{
An object of class <constructive_options/constructive_options_ordered>
}
\description{
These options will be used on objects of class 'ordered'.
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"ordered"} (default): Build the object using \code{ordered()}, levels won't
be defined explicitly if they are in alphabetical order (locale dependent!)
\item \code{"factor"} : Same as above but build the object using \code{factor()} and \code{ordered = TRUE}.
\item \code{"new_ordered"} : Build the object using \code{vctrs::new_ordered()}. Levels are
always defined explicitly.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"integer"} : We define as an integer vector and repair attributes
}
}
