% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.Bonferroni.R
\name{corr.Bonferroni}
\alias{corr.Bonferroni}
\title{ICC adjusted Bonferroni method}
\usage{
corr.Bonferroni(p, ICC, r = 0, alpha = 0.05)
}
\arguments{
\item{p}{A numeric vector. A length \eqn{m} P-value vector from multiple tests.}

\item{ICC}{A number. Intraclass correlation correction factor, a real number between (0, 1).}

\item{r}{A number. Tuning parameter for g** between (0, 1). Default \code{r=0}.}

\item{alpha}{A real number. \eqn{1-\alpha} is the confidence level, \code{alpha} must between (0, 1).}
}
\value{
A numeric vector of adjusted p-values.
}
\description{
\code{corr.Bonferroni} performs the ICC adjusted Bonferroni method proposed by
Shi, Pavey, and Carter(2012). Power law approximation by \code{r} is tricky, suggested
options was listed in the paper.
}
\examples{
m <- 10
corr.Bonferroni(
  p = runif(m),
  ICC = 0.3
)
}
\references{
Shi, Q., Pavey, E. S., & Carter, R. E. (2012). Bonferroni‐based correction factor for multiple, correlated endpoints. Pharmaceutical statistics, 11(4), 300-309.
}
