% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_template.R
\name{cf_download_template}
\alias{cf_download_template}
\alias{download_template}
\title{Download cowfootR Excel template}
\usage{
cf_download_template(file = "cowfootR_template.xlsx", include_examples = FALSE)

download_template(...)
}
\arguments{
\item{file}{Path where the template will be saved. Default = "cowfootR_template.xlsx".}

\item{include_examples}{Logical. If TRUE, includes example rows.}
}
\value{
Invisibly returns the file path.
}
\description{
Saves a blank Excel template with required columns for batch carbon footprint calculations.
}
\examples{
\dontshow{if (requireNamespace("writexl", quietly = TRUE)) { }
tf <- tempfile(fileext = ".xlsx")
on.exit(unlink(tf, force = TRUE), add = TRUE)
cf_download_template(tf)
\dontshow{ } }
}
\keyword{internal}
