% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dmix3}
\alias{dmix3}
\title{Probability mass function (PMF) of 3-component discrete extreme value mixture distribution}
\usage{
dmix3(x, v, u, alpha1, theta1, alpha2, theta2, shape, sigma, phi1, phi2, phiu)
}
\arguments{
\item{x}{Vector of positive integers}

\item{v}{Positive integer representing the lower threshold}

\item{u}{Positive integer representing the upper threshold}

\item{alpha1}{Real number, first parameter of the Zipf-polylog component below v}

\item{theta1}{Real number in (0, 1], second parameter of the Zipf-polylog component below v}

\item{alpha2}{Real number, first parameter of the Zipf-polylog component between v & u}

\item{theta2}{Real number in (0, 1], second parameter of the Zipf-polylog component between v & u}

\item{shape}{Real number, shape parameter of the generalised Pareto component}

\item{sigma}{Real number, scale parameter of the generalised Pareto component}

\item{phi1}{Real number in (0, 1), proportion of values below v}

\item{phi2}{Real number in (0, 1), proportion of values between v & u}

\item{phiu}{Real number in (0, 1), exceedance rate of the threshold u}
}
\value{
A numeric vector of the same length as x
}
\description{
\code{dmix3} returns the PMF at x for the 3-component discrete extreme value mixture distribution. The component below v is the (truncated) Zipf-polylog(alpha1,theta1) distribution, between v & u the (truncated) Zipf-polylog(alpha2,theta2) distribution, and above u the generalised Pareto(shape, sigma) distribution.
}
\seealso{
\code{\link{Smix3}} for the corresponding survival function, \code{\link{dpol}} and \code{\link{dmix2}} for the PMFs of the Zipf-polylog and 2-component discrete extreme value mixture distributions, respectively.
}
