% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFixedNames.R
\name{accRealmNames}
\alias{accRealmNames}
\title{Return the list of the realms and associated biomes and ecoregions.}
\usage{
accRealmNames(realm = NA, ecoregion = TRUE)
}
\arguments{
\item{realm}{A name of accepted realm. Default is \code{NA} and returns a
list of all the biome and ecoregion names sorted by realm.}

\item{ecoregion}{A boolean to choose whether to get the ecoregions names.}
}
\value{
A list with elements that correspond to the biomes (and possibly
ecoregions) of each realm.
}
\description{
Return the list of the realms and associated biomes and ecoregions.
}
\examples{
accRealmNames()
accRealmNames(realm='Africotropical')
accRealmNames(realm='Africotropical', ecoregion=FALSE)
}
\seealso{
\url{https://www.worldwildlife.org/publications/terrestrial-ecoregions-of-the-world}
}
