% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs-batch.R
\name{get_cancer_hazard_batch}
\alias{get_cancer_hazard_batch}
\title{Get cancer hazard batch}
\usage{
get_cancer_hazard_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSIDs}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between requests}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.table containing cancer hazard and
related data for each input DTXSID.
}
\description{
Get cancer hazard batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull cancer hazard data for multiples chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
dtxsid_cancer_hazard <- get_cancer_hazard_batch(DTXSID = dtxsid)
\dontshow{\}) # examplesIf}
}
