% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.drop.ind.r
\name{gl.drop.ind}
\alias{gl.drop.ind}
\title{Remove specified individuals from a genelight \{adegenet\} object}
\usage{
gl.drop.ind(x, ind.list, recalc = FALSE, mono.rm = TRUE, v = 2)
}
\arguments{
\item{x}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{ind.list}{-- a list of individuals to be removed [required]}

\item{recalc}{-- Recalculate the locus metadata statistics [default FALSE]}

\item{mono.rm}{-- Remove monomorphic loci [default TRUE]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A genlight object with the reduced data
}
\description{
The script, having deleted individuals, optionally identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r). The script also optionally
recalculates statistics made redundant by the deletion of individuals from the dataset.
}
\details{
The script returns a genlight object with the individuals deleted and, optionally, the recalculated locus metadata.
}
\examples{
   gl <- gl.drop.ind(testset.gl, ind.list=c("AA019073","AA004859"))
}
\seealso{
\code{\link{gl.filter.monomorphs}}

\code{\link{gl.recalc.metrics}}
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
