% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.plot.3d.r
\name{gl.pcoa.plot.3d}
\alias{gl.pcoa.plot.3d}
\title{3D interactive plot of the results of a PCoA ordination}
\usage{
gl.pcoa.plot.3d(x, gl, title = "PCoA", xaxis = 1, yaxis = 2,
  zaxis = 3, shape = "sphere", radius = 2, legend = "topright")
}
\arguments{
\item{x}{-- name of the glPca object containing the factor scores and eigenvalues [required]}

\item{gl}{-- name of the genlight object from which the PCoA was generated}

\item{title}{-- a title for the plot [default "PCoA"]}

\item{xaxis}{-- identify the x axis from those available in the ordination (xaxis <= nfactors) [default 1]}

\item{yaxis}{-- identify the y axis from those available in the ordination (yaxis <= nfactors) [default 2]}

\item{zaxis}{-- identify the z axis from those available in the ordination (zaxis <= nfactors) [default 3]}

\item{shape}{-- shape of the points, one of sphere, tetrahaedron or cube [default "sphere"]}

\item{radius}{-- size of the points [default 2]}

\item{legend}{-- one of bottomright, bottom, bottomleft, left, topleft, top, topright, right, center [default "bottom"]}
}
\value{
An interactive 3D plot of the ordination in a separate window
}
\description{
This script takes output from the ordination undertaken using gl.pcoa() and plots the individuals in 3D space. The visualisation
can be rotated with the mouse to examine the structure.
}
\details{
The factor scores are taken from the output of gl.pcoa(), an object of class glPca, and the population assignments from the original data file
and plots the specimens in a 3D plot.

Axes can be specified from the ordination, provided they are within the range of the nfactors value provided to gl.pcoa().

This script is essentially a wrapper for function pca3d \{pca3d\} maintained by January Weiner.
}
\examples{
library(rgl)  #needed for the example
pcoa <- gl.pcoa(testset.gl, nfactor=5)
gl.pcoa.plot.3d(pcoa, testset.gl, xaxis=1, yaxis=2, zaxis=3)
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
