% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/login_db.R
\name{login_db}
\alias{login_db}
\title{Log In To Databrary.org.}
\usage{
login_db(
  email = NULL,
  password = NULL,
  store = FALSE,
  overwrite = FALSE,
  vb = FALSE,
  SERVICE = "org.databrary.databraryr"
)
}
\arguments{
\item{email}{Databrary account email address.}

\item{password}{Databrary password (not recommended as it will displayed as you type)}

\item{store}{A boolean value. If TRUE store/retrieve credentials from the system keyring/keychain.}

\item{overwrite}{A boolean value. If TRUE and store is TRUE, overwrite/ update stored credentials in keyring/keychain.}

\item{vb}{A boolean value. If TRUE provides verbose output.}

\item{SERVICE}{A character label for stored credentials in the keyring. Default is "databrary"}
}
\value{
Logical value indicating whether log in is successful or not.
}
\description{
Log In To Databrary.org.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
login_db() # Queries user for email and password interactively.
\dontshow{\}) # examplesIf}
\donttest{
\dontrun{
# The following shows how to use credentials that have been stored previously.

login_db(email = "you@provider.com", store = TRUE)
}
}
}
