% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subnetwork_init_torch.R
\name{subnetwork_init_torch}
\alias{subnetwork_init_torch}
\title{Initializes a Subnetwork based on the Processed Additive Predictor}
\usage{
subnetwork_init_torch(
  pp,
  deep_top = NULL,
  orthog_fun = NULL,
  split_fun = split_model,
  shared_layers = NULL,
  param_nr = 1,
  selectfun_in = function(pp) pp[[param_nr]],
  selectfun_lay = function(pp) pp[[param_nr]],
  gaminputs,
  summary_layer = model_torch
)
}
\arguments{
\item{pp}{list of processed predictor lists from \code{processor}}

\item{deep_top}{In tf approach: keras layer if the top part of the deep network after orthogonalization; Not yet implemented for torch
is different to the one extracted from the provided network}

\item{orthog_fun}{function used for orthogonalization; Not yet implemented for torch}

\item{split_fun}{function to split the network to extract head}

\item{shared_layers}{list defining shared weights within one predictor;
each list item is a vector of characters of terms as given in the parameter formula}

\item{param_nr}{integer number for the distribution parameter}

\item{selectfun_in, selectfun_lay}{functions defining which subset of pp to
take as inputs and layers for this subnetwork; per default the \code{param_nr}'s entry}

\item{gaminputs}{input tensors for gam terms}

\item{summary_layer}{torch layer that combines inputs (typically adding or concatenating)}
}
\value{
returns a list of input and output for this additive predictor
}
\description{
Initializes a Subnetwork based on the Processed Additive Predictor
}
