% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.regL1.R
\name{boot.regL1}
\alias{boot.regL1}
\title{Bootstrapping Linear L1 Models}
\usage{
boot.regL1(x, y, R = 1000)
}
\arguments{
\item{x}{the regression design matrix.}

\item{y}{the regression response vector.}

\item{R}{the number of bootstrap replications.}
}
\value{
A list consisting of four elements: a vector of lambda mle estimate for each bootstrap sample and another vector with empirical quantiles. A matrix B of dimension R by p is returned with the R resampled estimates of the vector of L1 linear regression parameters. A matrix U of sampled indices.
}
\description{
This function can be used to construct standard errors,
confidence intervals and tests of hypotheses regarding linear L1
regression models. The bootstrap method used compute xypairs bootstrap
for linear L1 regression.
}
\examples{
\donttest{
data(stackloss)
bt1 = boot.regL1(stack.x, stack.loss, 1000)
plot(bt1$lambda_mle)
}


}
\seealso{
\code{\link[quantreg]{boot.rq}} Bootstrapping Quantile Regression from package \code{quantreg}.
}
