% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_het.regL1.R
\name{boot_het.regL1}
\alias{boot_het.regL1}
\title{Bootstrapping Linear L1 Models}
\usage{
boot_het.regL1(x, y, groups, R = 1000)
}
\arguments{
\item{x}{the regression design matrix.}

\item{y}{the regression response vector.}

\item{groups}{vector with the group index associated with the observation, observations with the same index belong to the same group.}

\item{R}{the number of bootstrap replications.}
}
\value{
A list consisting of four elements: a vector of lambda mle estimate for each bootstrap sample and another vector with empirical quantiles. A matrix B of dimension R by p is returned with the R resampled estimates of the vector of L1 linear regression parameters. A matrix U of sampled indices.
}
\description{
This function can be used to construct standard errors,
confidence intervals and tests of hypotheses regarding linear L1
regression models. The bootstrap method used compute xypairs bootstrap
for linear L1 regression.
}
\examples{
\donttest{
set.seed(123)
x1 = matrix(rnorm(20), ncol = 2)
y1 = x1[, 1] + x1[, 2] + rlaplace(10, 0, 5)
x2 = matrix(rnorm(20), ncol = 2)
y2 = x2[, 1] + x2[, 2] + rlaplace(10, 0, 10)
x3 = matrix(rnorm(20), ncol = 2)
y3 = x3[, 1] + x3[, 2] + rlaplace(10, 0, 15)
x4 = matrix(rnorm(20), ncol = 2)
y4 = x4[, 1] + x4[, 2] + rlaplace(10, 0, 20)
x5 = matrix(rnorm(20), ncol = 2)
y5 = x5[, 1] + x5[, 2] + rlaplace(10, 0, 30)

y = c(y1, y2, y3, y4, y5)
x = rbind(x1, x2, x3, x4, x5)
group_index = c(rep(1,10),rep(2,10),rep(3,10),rep(4,10),rep(5,10))

bt1 = boot_het.regL1(x, y, group_index, 1000)
bt1$lambda_mle_het
}


}
\seealso{
\code{\link[quantreg]{boot.rq}} Bootstrapping Quantile Regression from package \code{quantreg}.
}
