% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disclapmix_adaptive.R
\name{disclapmix_adaptive}
\alias{disclapmix_adaptive}
\title{Adaptive fitting}
\usage{
disclapmix_adaptive(x, margin = 5L, criteria = "BIC_marginal", ...)
}
\arguments{
\item{x}{Dataset.}

\item{margin}{Fit models until there is at least this margin}

\item{criteria}{The slot to chose the best model from (small values indicate better model)}

\item{\dots}{Passed on to `disclapmix_robust()` (and further to `disclapmix()`)}
}
\value{
A list of all `disclapmix` fits
}
\description{
A wrapper around `disclapmix_robust()` that instead of fitting one model 
for a given number of clusters, fits models until the best model (lowest marginal BIC) 
is in the interior (with margin `M`) of all number of clusters tried.
}
\details{
E.g., the best model has 3 clusters and the margin `M = 5`, then 
this function ensures that models with 1, 2, ..., 3+5 = 8 clusters 
are fitted. If e.g. then 7 is better than 3, then it continues such that 
also models with up to 7+5 = 12 clusters are fitted. 

Note that models with 1-5 clusters are always fitted.
}
\examples{
data(danes)
db <- as.matrix(danes[rep(1:nrow(danes), danes$n), 1:(ncol(danes)-1)])
fits <- disclapmix_adaptive(db, margin = 5L)
fits
BICs <- sapply(fits, function(x) x$BIC_marginal)
BICs
ks <- sapply(fits, function(x) nrow(x$y)) # Always same as seq_along(fits)
ks
max_k <- max(ks)
best_k <- which.min(BICs)
max_k
best_k
max_k - best_k # = margin = 5

}
