% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/disequilibrium_model.R,
%   R/diseq_basic.R, R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\docType{class}
\name{market_models}
\alias{market_models}
\alias{market_model-class}
\alias{disequilibrium_model-class}
\alias{diseq_basic-class}
\alias{diseq_deterministic_adjustment-class}
\alias{diseq_directional-class}
\alias{diseq_stochastic_adjustment-class}
\alias{equilibrium_model-class}
\title{Market model classes}
\description{
\subsection{diseq_basic}{
The basic disequilibrium model consists of three equations. Two of them
are the demand and supply equations. In addition, the model replaces the market
clearing condition with the short side rule. The model is estimated using full
information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\}.}
}

\subsection{diseq_deterministic_adjustment}{
The disequilibrium model with deterministic price adjustment consists
of four equations. The two market equations, the short side rule and price
evolution equation. The first two equations are stochastic. The price equation is
deterministic. The sample is separated based on the sign of the price changes as in
the \code{\linkS4class{diseq_directional}} model. The model is estimated using full
information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\},}
\deqn{\Delta P_{nt} = \frac{1}{\gamma} \left( D_{nt} - S_{nt} \right).}
}

\subsection{diseq_directional}{
The directional disequilibrium model consists of three equations and a
separation rule. The market is described by a linear demand, a linear supply
equation and the short side rule. The separation rule splits the sample into regimes
of excess supply and excess demand. If a price change is positive at the time point
of the observation, then the observation is classified as being in an excess demand
regime. Otherwise, it is assumed that it represents an excess supply state. The
model is estimated using full information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\},}
\deqn{\Delta P_{nt} \ge 0 \Longrightarrow D_{nt} \ge S_{nt}.}
}

\subsection{diseq_stochastic_adjustment}{
The disequilibrium model with stochastic price adjustment is described
by a system of four equations. Three of of them form a stochastic linear system of
market equations equations coupled with a stochastic price evolution equation. The
fourth equation is the short side rule. In contrast to the deterministic counterpart,
the model does not impose any separation rule on the sample. It is estimated using
full information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\},}
\deqn{\Delta P_{nt} =
    \frac{1}{\gamma} \left( D_{nt} - S_{nt} \right) +  X_{p,nt}'\beta_{p} + u_{p,nt}.}
}

\subsection{equilibrium_model}{
The equilibrium model consists of thee equations. The demand, the
supply and the market clearing equations. The model can be estimated using both full
information maximum likelihood and two-stage least squares.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = D_{nt} = S_{nt}.}

A necessary identification condition is that
there is at least one control that is exclusively part of the demand and one control
that is exclusively part of the supply equation. In the first stage of the two-stage
least square estimation, prices are regressed on remaining controls from both the
demand and supply equations. In the second stage, the demand and supply equation is
estimated using the fitted prices instead of the observed.
}
}
\section{Functions}{
\itemize{
\item \code{market_model-class}: Base class for market models

\item \code{disequilibrium_model-class}: Base class for disequilibrium models

\item \code{diseq_basic-class}: Basic disequilibrium model with unknown sample separation.

\item \code{diseq_deterministic_adjustment-class}: Disequilibrium model with deterministic price dynamics.

\item \code{diseq_directional-class}: Directional disequilibrium model with sample separation.

\item \code{diseq_stochastic_adjustment-class}: Disequilibrium model with stochastic price dynamics.

\item \code{equilibrium_model-class}: Equilibrium model
}}

\section{Slots}{

\describe{
\item{\code{logger}}{Logger object.}

\item{\code{key_columns}}{Vector of column names that uniquely identify data records. For
panel data this vector should contain an entity and a time point identifier.}

\item{\code{time_column}}{Column name for the time point data.}

\item{\code{explanatory_columns}}{Vector of explanatory column names for all model's
equations.}

\item{\code{data_columns}}{Vector of model's data column names. This is the union of the
quantity, price and explanatory columns.}

\item{\code{columns}}{Vector of primary key and data column names for all model's equations.}

\item{\code{model_tibble}}{Model data \code{tibble}.}

\item{\code{model_type_string}}{Model type string description.}

\item{\code{system}}{Model's system of equations.}
}}

\seealso{
initialize_market_model
}
