% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\name{scores}
\alias{scores}
\alias{scores,diseq_basic-method}
\alias{scores,diseq_deterministic_adjustment-method}
\alias{scores,diseq_directional-method}
\alias{scores,diseq_stochastic_adjustment-method}
\alias{scores,equilibrium_model-method}
\title{Likelihood scores.}
\usage{
scores(object, parameters)

\S4method{scores}{diseq_basic}(object, parameters)

\S4method{scores}{diseq_deterministic_adjustment}(object, parameters)

\S4method{scores}{diseq_directional}(object, parameters)

\S4method{scores}{diseq_stochastic_adjustment}(object, parameters)

\S4method{scores}{equilibrium_model}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector with model parameters.}
}
\value{
The score matrix.
}
\description{
It calculates the gradient of the likelihood at the given parameter point for each
observation in the sample. It, therefore, returns an n x k matrix, where n denotes
the number of observations in the sample and k the number of estimated parameters.
There order of the parameters is the same as the one that is used in the summary
of the results.
}
\examples{
\donttest{
model <- simulate_model(
  "diseq_basic", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.9, beta_d0 = 8.9, beta_d = c(0.6), eta_d = c(-0.2),
    # supply coefficients
    alpha_s = 0.9, beta_s0 = 4.2, beta_s = c(0.03, 1.2), eta_s = c(0.1)
  ),
  seed = 7523
)

# estimate the model object (BFGS is used by default)
est <- estimate(model)

# Calculate the score matrix
head(scores(model, est@coef))
}
}
