\name{make.ctable}
\alias{make.ctable}
\title{
%%  ~~function to do ... ~~
Generates a list of vectors containing sets of variance component names
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Internal function used by \code{dmm()} to construct vectors containing various subsets of the available variance component names, for use in testing and flow control. Made available at user level because it may be useful in constructing the \code{components} argument of \code{dmm()}.
}
\usage{
make.ctable()
}
\details{
%%  ~~ If necessary, more details than the description above ~~
There are at present 33 variance and cross-effect-covariance components available in \code{dmm()}. Each of these corresponds to a particular effect in a genetic model. Component names are used throughout \code{dmm()} to name rows and columns, and hence to label output. For the user, correct specification of component names is vital. The list generated by an internal call to \code{make.ctable()} is used to check validity, and to manage internal flow control.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
A list containing the following items:
\item{cohortvar}{Vector containing all variance components involving cohort}
\item{cohortcov}{Vector containing all covariance components involving cohort}
\item{cohort}{Vector containing all (co)variance components involving cohort}
\item{evar}{Vector containing all environmental variance comonents}
\item{ecov}{Vector containing all environments covariance components}
\item{e}{Vector containing all environmental (co)variance components}
\item{addgvar}{Vector containing all additive genetic variance components}
\item{domgvar}{Vector containing all dominance genetic variance components}
\item{epiaddgvar}{Vector containing all additive x additive epistatic genetic variance components}
\item{epidomgvar }{Vector containing all epistatic genetic variance components involving dominance}
\item{sexlinaddgvar}{Vector containing all sexlinked additive genetic variance components}
\item{gvar}{Vector containing all genetic variance components}
\item{allvar}{Vector containing all variance components}
\item{addgcov}{Vector containing all additive genetic covariance components}
\item{domgcov}{Vector containing all dominance genetic covariance components}
\item{epiaddgcov}{Vector containing all additive x additive epistatic genetic covariance components}
\item{epidomgcov}{Vector containing all epistatic genetic covariance components involving dominance}
\item{sexlinaddgcov}{Vector containing all sexlinked additive genetic covariance components}
\item{gcov}{Vector containing all genetic covariance components}
\item{g}{Vector containing all genetic (co)variance components}
\item{allcov}{Vector containing all covariance components}
\item{addg}{Vector containing all additive genetic (co)variance components}
\item{domg}{Vector containing all dominance genetic (co)variance components}
\item{epiaddg}{Vector containing all additive x additive epistatic genetic (co)variance components}
\item{epidomg}{Vector containing all epistatic genetic (co)variance components involving dominance}
\item{sexlinaddg}{Vector containing all sexlinked additive genetic (co)variance components}
\item{indvar}{Vector containing all individual variance components}
\item{indcov}{Vector containing all individual covariance components}
\item{ind}{Vector containing all individual (co)variance components}
\item{matvar}{Vector containing all maternal variance components}
\item{matcov}{Vector containing all maternal covariance components}
\item{mat}{Vector containing all maternal (co)variance components}
\item{all}{Vector containing all (co)variance components}
}
\author{
Neville Jackson
}
\note{
This is an internal function, its definition and its return value may change in future versions.

Component names are defined in the document \emph{dmmOverview.pdf}.
}

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
Function \code{dmm()}.
}
\examples{

library(dmm)
# make a ctable
tmp <- make.ctable()
# see its structure
str(tmp)
# look at all additive genetic variances
tmp$addgvar
# tidy up
rm(tmp)
}
\keyword{ misc }
