% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man.R
\name{usage}
\alias{usage}
\title{Return the Usage of a Function From Within the Function}
\usage{
usage(n = -1, usage = FALSE)
}
\arguments{
\item{n}{A negative integer giving the number of from to frames/environments
to go back (passed as \code{which} to \code{\link{sys.call}}). Set to
\code{-2} if you want to encapsulate the call to \code{usage} into a function
(like \code{\link{print}} or \code{\link{assign}}) within the function you
want to obtain the usage for.
Use the \code{<-} assignment operator with the default, see \bold{examples}
below.}

\item{usage}{Give this functions usage (as a usage example \ldots) and exit?}
}
\value{
A character string giving the Usage as \code{\link{help}} would do.
}
\description{
Get a usage template for a function from within the function if you encounter
misguided usage, you can display the template.
}
\examples{
# usage with assignment operator:
foo <- function(x) {
    u <- usage()
    message("Usage is: ", u)
}
foo()

# usage without assignment operator:
bar <- function(x) {
    message(usage(n = -2))
}
bar()
}
