% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogramDS2.R
\name{histogramDS2}
\alias{histogramDS2}
\title{Computes a histogram of the input variable without plotting.}
\usage{
histogramDS2(xvect, num.breaks, min, max, method.indicator, k, noise)
}
\arguments{
\item{xvect}{the numeric vector for which the histogram is desired.}

\item{num.breaks}{the number of breaks that the range of the variable is divided.}

\item{min}{a numeric, the lower limit of the distribution.}

\item{max}{a numeric, the upper limit of the distribution.}

\item{method.indicator}{a number equal to either 1, 2 or 3 indicating the method of disclosure
control that is used for the generation of the histogram. If the value is equal to 1 then the
'smallCellsRule' is used. If the value is equal to 2 then the 'deterministic' method is used.
If the value is set to 3 then the 'probabilistic' method is used.}

\item{k}{the number of the nearest neighbours for which their centroid is calculated if the 
\code{method.indicator} is equal to 2 (i.e. deterministic method).}

\item{noise}{the percentage of the initial variance that is used as the variance of the embedded
noise if the \code{method.indicator} is equal to 3 (i.e. probabilistic method).}
}
\value{
a list with an object of class \code{histogram} and the number of invalid cells
}
\description{
This function produces the information required to plot
a histogram. This is done without allowing for bins (cells) with number
of counts less than the pre-specified disclosure control set for the minimum cell
size of a table. If a bin has less counts than this threshold then their counts 
and its density are replaced by a 0 value.
}
\details{
Please find more details in the documentation of the clientside ds.histogram function.
}
\author{
Amadou Gaye, Demetris Avraam for DataSHIELD Development Team
}
