% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_extension.R
\name{ddbs_install}
\alias{ddbs_install}
\title{Checks and installs the Spatial extension}
\usage{
ddbs_install(conn, upgrade = FALSE)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}

\item{upgrade}{if TRUE, it upgrades the DuckDB extension to the latest version}
}
\value{
TRUE (invisibly) for successful installation
}
\description{
Checks if a spatial extension is available, and installs it in a DuckDB database
}
\examples{
## load packages
library(duckdb)
library(duckspatial)

## connect to in memory database
conn <- dbConnect(duckdb::duckdb())

## install the spatial exntesion
ddbs_install(conn)

## disconnect from db
dbDisconnect(conn)
}
