% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/axis.R
\name{dyAxis}
\alias{dyAxis}
\title{dygraph axis}
\usage{
dyAxis(dygraph, name, label = NULL, valueRange = NULL, ticker = NULL,
  rangePad = NULL, labelWidth = NULL, labelHeight = NULL,
  axisHeight = NULL, axisLineColor = NULL, axisLineWidth = NULL,
  pixelsPerLabel = NULL, axisLabelColor = NULL, axisLabelFontSize = NULL,
  axisLabelWidth = NULL, axisLabelFormatter = NULL, valueFormatter = NULL,
  drawGrid = NULL, gridLineColor = NULL, gridLineWidth = NULL,
  independentTicks = NULL)
}
\arguments{
\item{dygraph}{Dygraph to add an axis definition to}

\item{name}{Axis name ('x', 'y', or 'y2')}

\item{label}{Label to display for axis (defaults to none).}

\item{valueRange}{Explicitly set the vertical range of the graph to
\code{c(low, high)}. This may be set on a per-axis basis to define each
y-axis separately. If either limit is unspecified, it will be calculated
automatically (e.g. \code{c(NULL, 30)} to automatically calculate just the
lower bound).}

\item{ticker}{This lets you specify an arbitrary JavaScript function to
generate tick marks on an axis. The tick marks are an array of (value,
label) pairs. The built-in functions go to great lengths to choose good
tick marks so, if you set this option, you'll most likely want to call one
of them and modify the result. See dygraph-tickers.js and the
\href{http://dygraphs.com/options.html}{dygraphs documentation} for
additional details).}

\item{rangePad}{Add the specified amount of extra space (in pixels) around
the value range to ensure points at the edges remain visible.}

\item{labelWidth}{Width of the div which contains the y-axis label. Since the
y-axis label appears rotated 90 degrees, this actually affects the height
of its div.}

\item{labelHeight}{Height of the x-axis label, in pixels. This also controls
the default font size of the x-axis label. If you style the label on your
own, this controls how much space is set aside below the chart for the
x-axis label's div.}

\item{axisHeight}{Height, in pixels, of the x-axis. If not set explicitly,
this is computed based on \code{axisLabelFontSize} and \code{axisTickSize}.}

\item{axisLineColor}{Color of the x- and y-axis lines. Accepts any value
which the HTML canvas strokeStyle attribute understands, e.g. 'black' or
'rgb(0, 100, 255)'.}

\item{axisLineWidth}{Thickness (in pixels) of the x- and y-axis lines.}

\item{pixelsPerLabel}{Number of pixels to require between each x- and
y-label. Larger values will yield a sparser axis with fewer ticks. Defaults
to 50 (x-axis) or 30 (y-axes).}

\item{axisLabelColor}{Color for x- and y-axis labels. This is a CSS color
string. This may also be set globally using \code{dyOptions}.}

\item{axisLabelFontSize}{Size of the font (in pixels) to use in the axis
labels, both x- and y-axis. This may also be set globally using
\code{dyOptions}.}

\item{axisLabelWidth}{Width, in pixels, of the axis labels}

\item{axisLabelFormatter}{JavaScript function to call to format the tick
values that appear along an axis (see the
\href{http://dygraphs.com/options.html}{dygraphs documentation} for
additional details).}

\item{valueFormatter}{JavaScript function to call to provide a custom display
format for the values displayed on mouseover (see the
\href{http://dygraphs.com/options.html}{dygraphs documentation} for
additional details).}

\item{drawGrid}{Whether to display grid lines in the chart.}

\item{gridLineColor}{The color of the grid lines.}

\item{gridLineWidth}{Thickness (in pixels) of the grid lines drawn under the
chart.}

\item{independentTicks}{Only valid for y and y2, has no effect on x: This
  option defines whether the y axes should align their ticks or if they
  should be independent. Possible combinations: 1.) y=true, y2=false
  (default): y is the primary axis and the y2 ticks are aligned to the the
  ones of y. (only 1 grid) 2.) y=false, y2=true: y2 is the primary axis and
  the y ticks are aligned to the the ones of y2. (only 1 grid) 3.) y=true,
  y2=true: Both axis are independent and have their own ticks. (2 grids) 4.)
  y=false, y2=false: Invalid configuration causes an error.}
}
\value{
Axis options
}
\description{
Define options for an axis on a dygraph plot. Note that options will use the
default global setting (as determined by \code{\link{dyOptions}}) when not
specified explicitly.
}
\note{
See the
  \href{http://rstudio.github.io/dygraphs/gallery-axis-options.html}{online
  documentation} for additional details and examples.
}
\examples{
library(dygraphs)

dygraph(nhtemp, main = "New Haven Temperatures") \%>\%
  dyAxis("y", label = "Temp (F)", valueRange = c(40, 60)) \%>\%
  dyOptions(axisLineWidth = 1.5, fillGraph = TRUE, drawGrid = FALSE)
}

