% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamite-package.R
\docType{data}
\name{categorical_example_fit}
\alias{categorical_example_fit}
\title{Model Fit for the Simulated Categorical Multivariate Panel Data}
\format{
A \code{dynamitefit} object.
}
\source{
Script in
\url{https://github.com/ropensci/dynamite/blob/main/data-raw/categorical_example_fit.R}
}
\usage{
categorical_example_fit
}
\description{
A \code{dynamitefit} object obtained by running \code{dynamite} on the
\code{categorical_example} dataset as
\preformatted{
set.seed(1)
library(dynamite)
f <- obs(x ~ z + lag(x) + lag(y), family = "categorical") +
  obs(y ~ z + lag(x) + lag(y), family = "categorical")
categorical_example_fit <- dynamite(
  f,
  data = categorical_example,
  time = "time",
  group = "id",
  chains = 1,
  refresh = 0,
  thin = 5,
  save_warmup = FALSE
)
}
Note the small number of samples due to size restrictions on CRAN.
}
\seealso{
Example models
\code{\link{categorical_example}},
\code{\link{gaussian_example_fit}},
\code{\link{gaussian_example}},
\code{\link{gaussian_simulation_fit}},
\code{\link{multichannel_example_fit}},
\code{\link{multichannel_example}}
}
\concept{examples}
\keyword{datasets}
