% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{RFEAT_object}
\alias{RFEAT_object}
\title{Create a RFEAT object}
\usage{
RFEAT_object(
  data,
  x,
  y,
  rownames,
  numStop,
  m,
  s_mtry,
  na.rm,
  forest,
  error,
  OOB
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the variables in the model.}

\item{x}{Column input indexes in \code{data}.}

\item{y}{Column output indexes in \code{data}.}

\item{rownames}{\code{string}. Data rownames.}

\item{numStop}{Minimun number of observations in a node for a split to be attempted.}

\item{m}{Number of trees to be built.}

\item{s_mtry}{Select number of inputs in each split.
\itemize{
\item{\code{"Breiman"}}: \code{in / 3}
\item{\code{"DEA1"}}: \code{(t.obs / 2) - out}  
\item{\code{"DEA2"}}: \code{(t.obs / 3) - out}
\item{\code{"DEA3"}}: \code{t.obs - 2 * out}
\item{\code{"DEA4"}}: \code{min(t.obs / out, (t.obs / 3) - out)}
}}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}

\item{forest}{\code{list} containing the individual Efficiency Analysis Trees.}

\item{error}{Error in Random Forest for Efficiency Analysis Trees.}

\item{OOB}{\code{list} containing the observations with which each tree has been trained.}
}
\value{
A \code{RFEAT} object.
}
\description{
This function saves information about the Random Forest for Efficiency Analysis Trees model.
}
