% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize.R
\name{organize_names}
\alias{organize_names}
\title{This function allows you to organize the variables names of ECH with reference in 2017.}
\usage{
organize_names(data, year, level = "hyp")
}
\arguments{
\item{data}{data.frame contains the ECH microdata}

\item{year}{numeric reference year of the data. Available from 2011 to 2019}

\item{level}{(string) indicates whether the base to be labelled is of the type "household", "h", "individual", "i" or both, "hyp". Default "hyp"}
}
\value{
data.frame
}
\description{
This function allows you to organize the variables names of ECH with reference in 2017.
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_2018 <- organize_names(data = ech::toy_ech_2018, year = 2018, level = "h")
}
}
\seealso{
Other organize: 
\code{\link{to_ascii}()}
}
\concept{organize}
