% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsize.R, R/effectsize.htest.R
\name{effectsize}
\alias{effectsize}
\alias{effectsize.BFBayesFactor}
\alias{effectsize.aov}
\alias{effectsize.htest}
\title{Effect Size}
\usage{
effectsize(model, ...)

\method{effectsize}{BFBayesFactor}(model, type = NULL, verbose = TRUE, ...)

\method{effectsize}{aov}(model, type = NULL, ...)

\method{effectsize}{htest}(model, type = NULL, verbose = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{htest}, or a statistical model. See details.}

\item{...}{Arguments passed to or from other methods. See details.}

\item{type}{The effect size of interest. See details.}

\item{verbose}{Toggle warnings and messages on or off.}
}
\value{
A data frame with the effect size (depending on input) and and its
CIs (\code{CI_low} and \code{CI_high}).
}
\description{
This function tries to return the best effect-size measure for the provided
input model. See details.
}
\details{
\itemize{
\item For an object of class \code{htest}, data is extracted via \code{\link[insight:get_data]{insight::get_data()}}, and passed to the relevant function according to:
\itemize{
\item A \strong{t-test} depending on \code{type}: \code{"cohens_d"} (default), \code{"hedges_g"}.
\item A \strong{Chi-squared tests of independence or goodness-of-fit}, depending on \code{type}: \code{"cramers_v"} (default), \code{"phi"}, \code{"cohens_w"}, \code{"pearsons_c"}, \code{"cohens_h"}, \code{"oddsratio"}, or \code{"riskratio"}.
\item A \strong{One-way ANOVA test}, depending on \code{type}: \code{"eta"} (default), \code{"omega"} or \code{"epsilon"} -squared, \code{"f"}, or \code{"f2"}.
\item A \strong{McNemar test} returns \emph{Cohen's g}.
\item A \strong{Wilcoxon test} returns \emph{rank biserial correlation}.
\item A \strong{Kruskal-Wallis test} returns \emph{rank Epsilon squared}.
\item A \strong{Friedman test} returns \emph{Kendall's W}.
(Where applicable, \code{ci} and \code{alternative} are taken from the \code{htest} if not otherwise provided.)
}
\item For an object of class \code{BFBayesFactor}, using \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}},
\itemize{
\item A \strong{t-test} returns \emph{Cohen's d}.
\item A \strong{correlation test} returns \emph{r}.
\item A \strong{contingency table test}, depending on \code{type}: \code{"cramers_v"} (default), \code{"phi"}, \code{"cohens_w"}, \code{"pearsons_c"}, \code{"cohens_h"}, \code{"oddsratio"}, or \code{"riskratio"}.
}
\item Objects of class \code{anova}, \code{aov}, or \code{aovlist}, depending on \code{type}: \code{"eta"} (default), \code{"omega"} or \code{"epsilon"} -squared, \code{"f"}, or \code{"f2"}.
\item Other objects are passed to \code{\link[=standardize_parameters]{standardize_parameters()}}.
}

\strong{For statistical models it is recommended to directly use the listed
functions, for the full range of options they provide.}
}
\examples{

## Hypothesis Testing
## ------------------
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))
Xsq <- chisq.test(contingency_table)
effectsize(Xsq)
effectsize(Xsq, type = "phi")

Tt <- t.test(1:10, y = c(7:20), alternative = "less")
effectsize(Tt)

Aov <- oneway.test(extra ~ group, data = sleep, var.equal = TRUE)
effectsize(Aov)
effectsize(Aov, type = "omega")

Wt <- wilcox.test(1:10, 7:20, mu = -3, alternative = "less")
effectsize(Wt)

## Bayesian Hypothesis Testing
## ---------------------------
\donttest{
if (require(BayesFactor)) {
  bf1 <- ttestBF(mtcars$mpg[mtcars$am == 1], mtcars$mpg[mtcars$am == 0])
  effectsize(bf1, test = NULL)

  bf2 <- correlationBF(attitude$rating, attitude$complaints)
  effectsize(bf2, test = NULL)

  data(raceDolls)
  bf3 <- contingencyTableBF(raceDolls, sampleType = "poisson", fixedMargin = "cols")
  effectsize(bf3, test = NULL)
  effectsize(bf3, type = "oddsratio", test = NULL)
}
}

## Models and Anova Tables
## -----------------------
fit <- lm(mpg ~ factor(cyl) * wt + hp, data = mtcars)
effectsize(fit)

anova_table <- anova(fit)
effectsize(anova_table)
effectsize(anova_table, type = "epsilon")
}
\seealso{
Other effect size indices: 
\code{\link{cohens_d}()},
\code{\link{eta_squared}()},
\code{\link{phi}()},
\code{\link{rank_biserial}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
