% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmip.R
\name{emmip}
\alias{emmip}
\alias{emmip.default}
\title{Interaction-style plots for estimated marginal means}
\usage{
emmip(object, formula, ...)

\method{emmip}{default}(object, formula, type, CIs = FALSE, PIs = FALSE,
  style, engine = get_emm_option("graphics.engine"), pch = c(1, 2, 6, 7, 9,
  10, 15:20), lty = 1, col = NULL, plotit = TRUE,
  nesting.order = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{emmGrid}, or a fitted model of a class
supported by the \pkg{emmeans} package}

\item{formula}{Formula of the form 
\code{trace.factors ~ x.factors | by.factors}. The EMMs are
plotted against \code{x.factor} for each level of \code{trace.factors}.
\code{by.factors} is optional, but if present, it determines separate
panels. Each element of this formula may be a single factor in the model,
or a combination of factors using the \code{*} operator.}

\item{...}{Additional arguments passed to \code{\link{emmeans}} (when
\code{object} is not already an \code{emmGrid} object),
\code{predict.emmGrid},
\code{\link[ggplot2]{ggplot}}, or \code{\link[lattice]{xyplot}}.}

\item{type}{As in \code{\link{predict.emmGrid}}, this determines
whether we want to inverse-transform the predictions
(\code{type = "response"}) or not (any other choice). The default is
\code{"link"}, unless the \code{"predict.type"} option is in force; see
\code{\link{emm_options}}.}

\item{CIs}{Logical value. If \code{TRUE}, confidence intervals (or HPD intervals
for Bayesian models) are added to the plot 
(works only with \code{engine = "ggplot"}).}

\item{PIs}{Logical value. If \code{TRUE}, prediction intervals are added to the plot 
(works only with \code{engine = "ggplot"}). If both \code{CIs} and
\code{CIs} are \code{TRUE}, the prediction intervals will be somewhat
longer, lighter, and thinner than the confidence intervals. Additional
parameters to \code{\link{predict.emmGrid}} (e.g., \code{sigma}) may be passed via
\code{...}. For Bayesian models, PIs require \code{frequentist = TRUE} and 
a value for \code{sigma}.}

\item{style}{Optional character value. This has an effect only when the
horizontal variable is a single numeric variable. If \code{style} is
unspecified or \code{"numeric"}, the horizontal scale will be numeric and
curves are plotted using lines (and no symbols). With \code{style =
"factor"}, the horizontal variable is treated as the levels of a factor
(equally spaced along the horizontal scale), and curves are plotted using
lines and symbols. When the horizontal variable is character or factor, or
a combination of more than one predictor, \code{"factor"} style is always used.}

\item{engine}{Character value matching \code{"ggplot"} (default) or 
\code{"lattice"}. The graphics engine to be used to produce the plot.
These require, respectively, the \pkg{ggplot2} or \pkg{lattice} package to
be installed.}

\item{pch}{The plotting characters to use for each group (i.e., levels of
\code{trace.factors}). They are recycled as needed.}

\item{lty}{The line types to use for each group. Recycled as needed.}

\item{col}{The colors to use for each group, recycled as needed. If not
specified, the default trellis colors are used.}

\item{plotit}{Logical value. If \code{TRUE}, a graphical object is returned;
if \code{FALSE}, a data.frame is returned containing all the values
used to construct the plot.}

\item{nesting.order}{Logical value. If \code{TRUE}, factors that are nested
are presented in order according to their nesting factors, even if those nesting
factors are not present in \code{formula}. If \code{FALSE}, only the
variables in \code{formula} are used to order the variables.}
}
\value{
If \code{plotit = FALSE}, a \code{data.frame} (actually, a
  \code{summary_emm} object) with the table of EMMs that would be plotted.
  The variables plotted are named \code{xvar} and \code{yvar}, and the trace
  factor is named \code{tvar}. This data frame has an added \code{"labs"}
  attribute containing the labels \code{xlab}, \code{ylab}, and \code{tlab}
  for these respective variables. The confidence limits are also
  included, renamed \code{LCL} and \code{UCL}.

If \code{plotit = TRUE}, the function
  returns an object of class \code{"ggplot"} or a \code{"trellis"}, depending
  on \code{engine}.
}
\description{
Creates an interaction plot of EMMs based on a fitted model and a simple
formula specification.
}
\note{
Conceptually, this function is equivalent to 
  \code{\link{interaction.plot}} where the summarization function is thought 
  to return the EMMs.
}
\section{Details}{

If \code{object} is a fitted model, \code{\link{emmeans}} is called with an
appropriate specification to obtain estimated marginal means for each
combination of the factors present in \code{formula} (in addition, any 
arguments in \code{\dots} that match \code{at}, \code{trend}, 
\code{cov.reduce}, or \code{fac.reduce} are passed to \code{emmeans}). 
Otherwise, if \code{object} is an \code{emmGrid} object, its first element is 
used, and it must contain one estimate for each combination of the factors
present in \code{formula}.
}

\examples{
#--- Three-factor example
noise.lm = lm(noise ~ size * type * side, data = auto.noise)

# Separate interaction plots of size by type, for each side
emmip(noise.lm, type ~ size | side)

# One interaction plot, using combinations of size and side as the x factor
# ... with added confidence intervals
emmip(noise.lm, type ~ side * size, CIs = TRUE)

# One interaction plot using combinations of type and side as the trace factor
emmip(noise.lm, type * side ~ size)

# Individual traces in panels
emmip(noise.lm, ~ size | type * side)

# Example for the 'style' argument
fib.lm = lm(strength ~ machine * sqrt(diameter), data = fiber)
fib.rg = ref_grid(fib.lm, at = list(diameter = c(3.5, 4, 4.5, 5, 5.5, 6)^2))
emmip(fib.rg, machine ~ diameter)   # curves (because diameter is numeric)
emmip(fib.rg, machine ~ diameter, style = "factor")  # points and lines

# For an example using extra ggplot2 code, see 'vignette("messy-data")',
# in the section on nested models.
}
\seealso{
\code{\link{emmeans}}, \code{\link{interaction.plot}}.
}
