\name{power.trend}
\alias{power.trend}
\title{ Calculates power by simulation to detect a specified trend.}

\description{
Calculates power for a specified trend wherethe signal for the trend is specified by xvalues and meanvalues (possibly
generated by generate.trend), and the error distribution is specified by distribution. The statistical method to detect
the trend
is specified by method.The power is the proportion of repeat simulations for which the trend is detected with a p-value
less than alpha (two-sided test).
}

\usage{power.trend(xvalues, reps=1,  meanvalues, distribution="Normal", sd=NA,
  nbsize=NA, method="linear regression", alpha=0.05, nsims=1000, nsims.mk=999,
  randeffect=F, randeffect.sd=NA)
}

\arguments{
  \item{xvalues}{Vector of, for example, time points at which the trend is evaluated.}

  \item{reps}{Vector of number of replicates per time point.}

  \item{meanvalues}{Vector of mean values that identify the signal of the trend.}

  \item{distribution}{ Distribution (must be one of \code{"Normal"}, \code{"Poisson"} or \code{"Negbin"} used to
        generate random values based on the signal in \code{meanvalues}.}

  \item{sd}{ Standard deviation if distribution=\code{"Normal"}.}

  \item{nbsize}{ Size parameter if distribution=\code{"Negbin"}.}

  \item{method}{ Method used to identify the trend. Can be one of \code{"linear regression"}, \code{"mk"}, or
        \code{"gam"}. The last of these fits a Generalised
        Additive Model (Wood, 2006) using function \code{\link[mgcv]{gam}}. It assumes Normal errors.}

  \item{alpha}{ Type 1 error for detecting trend. Values less than \code{alpha} cause the null hypothesis of
                \code{no trend} to be rejected. Tests are 2-sided. }

  \item{nsims}{ The number of simulations to be used in calculating the power. Default is 1000.}

  \item{nsims.mk}{ The number of replicate permutations used in calculating the p-value for the Mann-Kendall test
                   when \code{method=mk}. Default is 999.}
  \item{randeffect}{Not working yet}
  \item{randeffect.sd}{Not working yet}
}
\details{
The Mann Kendall tests are approriate only for monotonic increasing or decreasing trends, the linear regression
method is
only approriate for linearly increasing or decreasing trend. The GAM is appropriate for changing trends over time.

Several powers can be calculated on a single call to this function by placing more than one value in \code{reps}.
}
\value{ The power is returned. }

\references{
Fryer RJ & Nicholson MD (1993) Need paper title. ICES Journal of Marine Science, 50, 161-168.

Fryer & Nicholson 1999 Using smoothers for comprehensive assessments of contaminant time series in marine biota.
ICES Journal of Marine Science, 56, 779-790.

Wood S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman and Hall/CRC Press.
}

\author{
David Maxwell: david.maxwell@cefas.co.uk
}

\seealso{\code{\link{mannkendall.stat}}, \code{\link{addnoise}},
         \code{\link[mgcv]{gam}}, \code{\link{generate.trend}}}

\examples{

library(mgcv)

# In practice, \code{nsims} would be set to at least 1000

par(mfrow=c(2,2))
lin5 = generate.trend(nyears=10, change=5, type="linear")
plot(lin5$i, lin5$mu)
updown = generate.trend(nyears=15, change=5, type="updown", changeyear=8)
plot(updown$i, updown$mu)

power.trend(xvalues=lin5$i, meanvalues=lin5$mu, distribution="Normal", sd=2,
            method="linear regression", alpha=0.05, nsims=50)
power.trend(xvalues=lin5$i, meanvalues=lin5$mu, distribution="Poisson", method="mk", alpha=0.05,
      nsims=50)
power.trend(xvalues=updown$i, meanvalues=updown$mu, distribution="Normal", sd=2,
            method="gam", alpha=0.05, nsims=50)
}

\keyword{ power }
\keyword{ trend }
\keyword{ Mann-Kendall }
\keyword{ gam }
