% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_estados.R
\name{padronizar_estados}
\alias{padronizar_estados}
\title{Padronizar estados}
\usage{
padronizar_estados(estados, formato = "por_extenso")
}
\arguments{
\item{estados}{Um vetor de caracteres ou números. Os estados a serem
padronizados.}

\item{formato}{Uma string. Como o resultado padronizado deve ser formatado.
Por padrão, \code{"por_extenso"}, fazendo com que a função retorne o nome dos
estados por extenso. Se \code{"sigla"}, a função retorna a sigla dos estados.}
}
\value{
Um vetor de caracteres com os estados padronizados.
}
\description{
Padroniza um vetor de caracteres ou números representando estados
brasileiros. Veja a seção \emph{Detalhes} para mais informações sobre a
padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item conversão para caracter, se o input for numérico;
\item remoção de espaços em branco antes e depois dos valores e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de zeros à esquerda;
\item busca, a partir do código numérico ou da abreviação da UF, do nome
completo de cada estado;
\item caso a busca não tenha encontrado determinado valor, remoção de acentos e
caracteres não ASCII.
}
}

\examples{
estados <- c("21", "021", "MA", " 21", " MA ", "ma", "", NA)
padronizar_estados(estados)

estados <- c(21, NA)
padronizar_estados(estados)
padronizar_estados(estados, formato = "sigla")

}
