% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.utility.R
\name{nvattr.copy.network}
\alias{nvattr.copy.network}
\title{Copy network- and vertex-level attributes between two network objects}
\usage{
nvattr.copy.network(
  to,
  from,
  ignore = c("bipartite", "directed", "hyper", "loops", "mnext", "multiple", "n")
)
}
\arguments{
\item{to}{the \code{\link[network:network]{network}} that attributes should be copied to}

\item{from}{the \code{\link[network:network]{network}} that attributes should be copied to}

\item{ignore}{vector of charcter names of network attributes that should not
be copied. Default is the standard list of network properties created by
\code{\link[network:network.initialize]{network.initialize()}}}
}
\value{
returns the \code{to} network, with attributes copied from
\code{from}
}
\description{
An internal ergm utility function to copy the network-level attributes and
vertex-level attributes from one \code{\link[network:network]{network}} object to another,
ignoring some standard properties by default.
}
\note{
does not check that networks are of the same size, etc
}
\seealso{
\code{\link[network:attribute.methods]{set.vertex.attribute()}},
\code{\link[network:attribute.methods]{set.network.attribute()}}
}
\keyword{internal}
