% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_plus_three.R
\name{three_plus_three}
\alias{three_plus_three}
\title{Fit the 3+3 model to some outcomes.}
\usage{
three_plus_three(
  outcomes,
  num_doses,
  allow_deescalate = FALSE,
  strict_mode = TRUE
)
}
\arguments{
\item{outcomes}{Outcomes observed. See \code{\link{parse_phase1_outcomes}}.}

\item{num_doses}{Number of doses under investigation.}

\item{allow_deescalate}{TRUE to allow de-escalation, as described by Korn et
al. Default is FALSE.}

\item{strict_mode}{TRUE to raise errors if it is detected that the 3+3
algorithm has not been followed.}
}
\value{
lits containing recommended_dose and a logical value continue saying
whether the trial should continue.
}
\description{
Fit the 3+3 model to some outcomes.
}
\examples{

three_plus_three('2NNN 3NNT', num_doses = 7)

}
\references{
Storer BE. Design and Analysis of Phase I Clinical Trials. Biometrics.
1989;45(3):925-937. doi:10.2307/2531693

Korn EL, Midthune D, Chen TT, Rubinstein LV, Christian MC, Simon RM.
A comparison of two phase I trial designs. Statistics in Medicine.
1994;13(18):1799-1806. doi:10.1002/sim.4780131802
}
